<?php
/*************************************************************
svgPHPGrapher by Murray Bourne, IntMath.com

svgPHPGrapher is a highly modified PHP port of Peter Jipsen's ASCIIsvg.js
http://www1.chapman.edu/~jipsen/svg/ASCIIsvg.js

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or (at
your option) any later version.

This program is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License (at http://www.gnu.org/copyleft/gpl.html) 
for more details.

****************************************************************/


//////////////////////////////////////////////////////
//
// evalmath serves a similar function to ASCIIMathML (evaluates plain English math functions)
//
/////////////////////////////////////////////////////

include('evalmath.class.php');

//////////////////////////////////////////////////////
//
// "Global" variables
//
//////////////////////////////////////////////////////

//$svgphp = 1;
$attrs = '';
$gridAttrs = 'stroke:#ccc; stroke-width:1; shape-rendering:crispEdges';
$axesAttrs = 'stroke:#444; stroke-width:1; shape-rendering:crispEdges';
$xAxisVbl = "x";
$yAxisVbl = "y";
$arrows = 1;
$padding = 15;
$axisClass = "intmath";
$axisVblClass = "intmathItalic";
$class = "intmath";
$axesType = "linlin"; 
$res1 = ''; $res2=''; $res3=''; // These are "reserve" variables
$svgTitle='';
//

//////////////////////////////////////////////////////
//
// Non-graphing functions
//
//////////////////////////////////////////////////////

function getCurvePoints($ptsArr, $tension, $isClosed, $numSegs) {
	///////////////////////////////////
	//
	//  Based on K3N's StackOverflow answer here: 
	//  http://stackoverflow.com/questions/7054272/how-to-draw-smooth-curve-through-n-points-using-javascript-html5-canvas
	//
	//////////////////////////////////
    // Use input value if provided, or use a default value   
    $tension = ($tension != 'undefined') ? $tension : 0.5;
    $isClosed = $isClosed ? $isClosed : false;
    $numSegs = $numSegs ? $numSegs : 16;
	 $res = [];   
    // The algorithm requires a previous and next point to the actual point array.
    // If closed, copy end point to beginning and first point to end
    // If open, duplicate first point to beginning, end point to end
    if ($isClosed) {		 
        array_unshift($ptsArr, end($ptsArr));		  
		  $ptsArr[] = $ptsArr[1];
		  $ptsArr[] = $ptsArr[2];
    }
    else {
		  array_unshift($ptsArr, $ptsArr[0]);
		  $ptsArr[] = end($ptsArr);
    }
    // First loop goes through point array
    // Second loop goes through each segment between the 2 pts + 1e point before and after
    for ($i=1; $i < (count($ptsArr)-2); $i++) {
        for ($t=0; $t <= $numSegs; $t++) {
            // calc $tension vectors
            $t1x = ($ptsArr[$i+1][0] - $ptsArr[$i-1][0]) * $tension;
            $t2x = ($ptsArr[$i+2][0] - $ptsArr[$i][0]) * $tension;
            $t1y = ($ptsArr[$i+1][1] - $ptsArr[$i-1][1]) * $tension;
            $t2y = ($ptsArr[$i+2][1] - $ptsArr[$i][1]) * $tension;
            // calc step
            $st = $t / $numSegs;
            // calc cardinals
            $c1 =   2 * pow($st, 3)  - 3 * pow($st, 2) + 1; 
            $c2 = -(2 * pow($st, 3)) + 3 * pow($st, 2); 
            $c3 =       pow($st, 3)  - 2 * pow($st, 2) + $st; 
            $c4 =       pow($st, 3)  -     pow($st, 2);
            // calc x and y cords with common control vectors
            $x = $c1 * $ptsArr[$i][0]  + $c2 * $ptsArr[$i+1][0] + $c3 * $t1x + $c4 * $t2x;
            $y = $c1 * $ptsArr[$i][1]  + $c2 * $ptsArr[$i+1][1] + $c3 * $t1y + $c4 * $t2y;
            //store points in array
            $tmp[] = $x;
            $tmp[] = $y;
				$res[] = $tmp;
				unset($tmp);
        }  
    }
    return $res;
}

function getRotAteangle($p, $q, $xunitlength, $yunitlength) {
	if ($q[0] == $p[0]) {
		if($q[1] > $p[1]) { 
			$rotateAngleRad = pi()/2;
		} else {
			$rotateAngleRad = 0;	
		}
	} else {
		$rotateAngleRad = - atan( (($q[1] - $p[1])*$yunitlength) / (($q[0] - $p[0])*$xunitlength) );
	}
	if($q[0] < $p[0]) {	
		$rotateAngleRad = pi() + $rotateAngleRad;
	} 
	return $rotateAngleRad;
}

// Function get_string_between($string, $start, $end)
// is now in includes/functions.php


// Source: http://stackoverflow.com/questions/5736398/how-to-calculate-the-svg-path-for-an-arc-of-a-circle
function polarToCartesian($centerX, $centerY, $radius, $angleInDegrees) {
  $angleInRadians = (-$angleInDegrees) * pi() / 180.0;
  return [$centerX + ($radius * cos($angleInRadians)), $centerY + ($radius * sin($angleInRadians))];
}
  
function solveQuadratic($a, $b, $c) {
	$r0 = (-$b - sqrt(pow($b,2) - 4*$a*$c) )/(2*$a);
	$r1 = (-$b + sqrt(pow($b,2) - 4*$a*$c) )/(2*$a);
	$solArr = [$r0, $r1];
	return $solArr;
}  

///////////////////////////////////////
//
// Grapher functions
//
///////////////////////////////////////


// Source: http://stackoverflow.com/questions/5736398/how-to-calculate-the-svg-path-for-an-arc-of-a-circle
/////////////////////////////////////////
//
// This gives ray -> arc -> ray
//
/////////////////////////////////////////////
function angleArc($p, $radius, $startAngle, $endAngle, $attrs, $brdParams) {  // pixels and degrees
	if(is_array($brdParams)) {
		foreach($brdParams as $key=>$val){
			${$key} = $val;
			//echo "$key=$val<br>";
		}	
	} else {
		echo "<div class=\"svgphpgrapherwarn\">There's a problem. Do you have the correct number of parameters for the <code>".__FUNCTION__."</code> function?</div>";
		return;
	}
	$svg = "<path ";
	$attrArr = explode(";", $attrs);
	foreach($attrArr as $attPairs) {
	  $attPairsArr = explode(":", trim($attPairs));
	  $svg .= "$attPairsArr[0]=\"$attPairsArr[1]\" ";		  
	}
	
	$start = polarToCartesian($p[0]*$xunitlength+$ox, ($height - $p[1]*$yunitlength - $oy), $radius, $startAngle);
	$end = polarToCartesian($p[0]*$xunitlength+$ox, ($height - $p[1]*$yunitlength - $oy), $radius, $endAngle);
//*cos($endAngle*PI()/180)	  * sin($endAngle*PI()/180)
	
	//$startCart = [ cos($startAngle*PI()/180) * $radius/$xunitlength, sin($startAngle*PI()/180) * $radius/(sqrt(pow($xunitlength,2) + pow($yunitlength,2))) ];
	$endCart = [ cos($endAngle*PI()/180) * $radius/$xunitlength, sin($endAngle*PI()/180) * $radius/$yunitlength ];
	//$arrowXvalStart = $endCart[0] + $endCart[1]*cos((90-$endAngle)*PI()/180);

	
	$largeArcFlag = ($endAngle - $startAngle <= 180) ? "0" : "1";
	//$largeArcFlag = 1;
//echo "<br />largeArcFlag = $largeArcFlag<br />";	
	
	$st = "d = \"M";
	$st .= ($start[0]) . "," . ($start[1]) . " A" . $radius . "," . $radius . " 0 " . $largeArcFlag . " 0 " . ($end[0]) . "," . ($end[1]) . 
			" L" .  ($end[0]) . "," . ($end[1]) . " " . ($p[0]*$xunitlength+$ox) . "," . ($height - $p[1]*$yunitlength - $oy) . " Z";				 
	$svg .= $st."\"";
	$svg .= ">";
	$svg .= "</path>\n";

	
	return $svg;  
}

// Source: http://stackoverflow.com/questions/5736398/how-to-calculate-the-svg-path-for-an-arc-of-a-circle
/////////////////////////////////////////
//
// This gives an arc with an arrow at the end (no rays)
//
/////////////////////////////////////////////
function angleArcArrow($p, $radius, $startAngle, $endAngle, $arcAttrs, $arrAttrs, $brdParams) {  // pixels and degrees
	if(is_array($brdParams)) {
		foreach($brdParams as $key=>$val){
			${$key} = $val;
			//echo "$key=$val<br>";
		}	
	} else {
		echo "<div class=\"svgphpgrapherwarn\">There's a problem. Do you have the correct number of parameters for the <code>".__FUNCTION__."</code> function?</div>";
		return;
	}
	$svg = "<path ";
	$attrArr = explode(";", $arcAttrs);
	foreach($attrArr as $attPairs) {
	  $attPairsArr = explode(":", trim($attPairs));
	  $svg .= "$attPairsArr[0]=\"$attPairsArr[1]\" ";		  
	}
	
	/////////////////////////////////////////////
	//
	// Negative angle case - swap start and end
	//
	/////////////////////////////////////////////
	$start = polarToCartesian($p[0]*$xunitlength+$ox, ($height - $p[1]*$yunitlength - $oy), $radius, $startAngle);
	$end = polarToCartesian($p[0]*$xunitlength+$ox, ($height - $p[1]*$yunitlength - $oy), $radius, $endAngle);
	if ($endAngle - $startAngle < 0) {
		$startRem[0] = $start[0];
		$startRem[1] = $start[1];
		$start[0] = $end[0];
		$start[1] = $end[1];
		$end[0] = $startRem[0];
		$end[1] = $startRem[1];
		
	}
//*cos($endAngle*PI()/180)	  * sin($endAngle*PI()/180)
	
	//$startCart = [ cos($startAngle*PI()/180) * $radius/$xunitlength, sin($startAngle*PI()/180) * $radius/(sqrt(pow($xunitlength,2) + pow($yunitlength,2))) ];
	$endCart = [ $p[0] + cos($endAngle*PI()/180) * $radius/$xunitlength, $p[1] + sin($endAngle*PI()/180) * $radius/$yunitlength ];
	//$arrowXvalStart = $endCart[0] + $endCart[1]*cos((90-$endAngle)*PI()/180);

	
	$largeArcFlag = ($endAngle - $startAngle <= 180) ? "0" : "1";
	
	if ($endAngle - $startAngle < -180 && $endAngle - $startAngle >= -270) {
		$largeArcFlag = "1";
	}
	
	//$largeArcFlag = 1;
//echo "<br />largeArcFlag = $largeArcFlag<br />";	
	
	$st = "d = \"M";
	$st .= ($start[0]) . "," . ($start[1]) . " A" . $radius . "," . $radius . " 0 " . $largeArcFlag . " 0 " . ($end[0]) . "," . ($end[1]);				 
	$svg .= $st."\"";
	$svg .= ">";
	$svg .= "</path>\n";
	
	$brdParams['actualXmin'] = $brdParams['xmin'] - $brdParams['padding']/$brdParams['xunitlength'];
	$brdParams['actualXmax'] = $brdParams['xmax'] + $brdParams['padding']/$brdParams['xunitlength'];
	$brdParams['actualYmin'] = $brdParams['ymin'] - $brdParams['padding']/$brdParams['yunitlength'];
	$brdParams['actualYmax'] = $brdParams['ymax'] + $brdParams['padding']/$brdParams['yunitlength'];
//printR($brdParams);

	if ($endAngle - $startAngle < 0) {
		$arrowXvalStart = $endCart[0] + $endCart[1]/tan((90-$endAngle)*PI()/180);
		$arrowYvalStart = 0;
	} else if ($endAngle - $startAngle < 90) {
		$arrowXvalStart = $endCart[0] + $endCart[1]/tan((90-$endAngle)*PI()/180);
		$arrowYvalStart = 0;
	} else if ($endAngle - $startAngle == 90) {
		$arrowXvalStart = $brdParams['actualXmax'];
		$arrowYvalStart = $endCart[1];
	} else if ($endAngle - $startAngle > 90 && $endAngle - $startAngle <= 180)  {
		
		$arrowXvalStart = $endCart[0] + ($brdParams['actualYmax']-$endCart[1])/tan(($endAngle-90)*PI()/180);
		$arrowYvalStart = $brdParams['actualYmax'];
		
	} else if ($endAngle - $startAngle > 180 && $endAngle - $startAngle <= 270) {
		$arrowXvalStart = $endCart[0] + $endCart[1]/tan((90-$endAngle)*PI()/180);
		$arrowYvalStart = 0;
	} else if ($endAngle - $startAngle <= 360) {
		$arrowXvalStart = $endCart[0] - ($endCart[1] - $brdParams['actualYmin'])/tan(($endAngle-270)*PI()/180);
		$arrowYvalStart = $brdParams['actualYmin'];
	}
/*echo $endCart[0],", ".$endCart[1];	
echo "<br />*** ".$arrowXvalStart."<br />";	
echo "<br />startAngle = $startAngle deg<br />";
echo "<br />endAngle = $endAngle deg<br />";
echo "<br />".$end[0]."<br />";	
echo "<br />".$end[1]."<br />";	
echo "<br />".$endCart[0].", ".$endCart[1]."<br />";
echo "<br />".(($endCart[1] - $brdParams['actualYmin']))."<br />";		
	//
	*/
	
	/*$arrAttrArr = explode(";", $arrAttrs);
	foreach($arrAttrArr as $attPairs) {
	  $attPairsArr = explode(":", trim($attPairs));
	  $svg .= "$attPairsArr[0]=\"$attPairsArr[1]\" ";		  
	}*/	
	
	//
	$svg .= arrowHead([$arrowXvalStart, $arrowYvalStart], $endCart, $arrAttrs,$brdParams);
	
	return $svg;  
}

function arc2($p, $radius, $startAngle, $endAngle, $attrs, $brdParams) {
	if(is_array($brdParams)) {
		foreach($brdParams as $key=>$val){
			${$key} = $val;
			//echo "$key=$val<br>";
		}	
	} else {
		echo "<div class=\"svgphpgrapherwarn\">There's a problem. Do you have the correct number of parameters for the <code>".__FUNCTION__."</code> function?</div>";
		return;
	}
	$svg = "<path ";
	$attrArr = explode(";", $attrs);
	foreach($attrArr as $attPairs) {
	  $attPairsArr = explode(":", trim($attPairs));
	  $svg .= "$attPairsArr[0]=\"$attPairsArr[1]\" ";		  
	}
	
	$start = polarToCartesian($p[0]*$xunitlength+$ox, ($height - $p[1]*$yunitlength - $oy), $radius*$xunitlength, $startAngle);
	$end = polarToCartesian($p[0]*$xunitlength+$ox, ($height - $p[1]*$yunitlength - $oy), $radius*$xunitlength, $endAngle);
	
	
//echo "<br />".$start[0]."<br />";	
//echo "<br />".$start[1]."<br />";
//echo "<br />".$end[0]."<br />";	
//echo "<br />".$end[1]."<br />";

	
	$largeArcFlag = ($endAngle - $startAngle <= 180) ? "0" : "1";
	$st = "d = \"M";
	$st .= ($start[0]) . "," . ($start[1]) . " A" . $radius*$xunitlength . "," . $radius*$xunitlength . " 0 " . $largeArcFlag . " 0 " . ($end[0]) . "," . ($end[1]) ;				 
	$svg .= $st."\"";
	$svg .= ">";
	$svg .= "</path>\n";	
	return $svg;  
}



function arc($start,$end,$radius, $attrs, $brdParams) {
	if(is_array($brdParams)) {
		foreach($brdParams as $key=>$val){
			${$key} = $val;
			//echo "$key=$val<br>";
		}	
	} else {
		echo "<div class=\"svgphpgrapherwarn\">There's a problem. Do you have the correct number of parameters for the <code>".__FUNCTION__."</code> function?</div>";
		return;
	}
	if ($radius==null) {
	 $v=[$end[0]-$start[0],$end[1]-$start[1]];
	 $radius =sqrt($v[0]*$v[0]+$v[1]*$v[1]);
	}
	$svg = "<path ";
	$attrArr = explode(";", $attrs);
	foreach($attrArr as $attPairs) {
	  $attPairsArr = explode(":", trim($attPairs));
	  $svg .= "$attPairsArr[0]=\"$attPairsArr[1]\" ";		  
	}
	$st = "d = \"M";
	$st .= ($start[0]*$xunitlength+$ox).",".
			 ($height-$start[1]*$yunitlength-$oy)." A".$radius*$xunitlength.",".
			  $radius*$yunitlength." 0 0,0 ".($end[0]*$xunitlength+$ox).",".
			 ($height-$end[1]*$yunitlength-$oy);
	$svg .= $st."\"";
	$svg .= ">";
	$svg .= "</path>\n";	
	return $svg;   
}

function arrowHead($p, $q, $attrs,$brdParams) { // draw arrow head at q (in cartesian coords)
	if(is_array($brdParams)) {
		foreach($brdParams as $key=>$val){
			${$key} = $val;
			//echo "$key=$val<br>";
		}	
	} else {
		echo "<div class=\"svgphpgrapherwarn\">There's a problem. Do you have the correct number of parameters for the <code>".__FUNCTION__."</code> function?</div>";
		return;
	}
	$svg = "<path ";
	$attrs = trim($attrs, ";");
	$attrArr = explode(";", $attrs);
	$attrArrVals = array();
	foreach($attrArr as $attPairs) {
		$attPairsArr = explode(":", trim($attPairs));
		foreach($attPairsArr as $key=>$val){
			${$key} = $val;
		}
		$thisKey = str_replace("-", "", $attPairsArr[0]);
		$$thisKey = $attPairsArr[1];
	}
	if(isset($stroke)) {$svg .= "stroke=\"$stroke\" ";} else {$svg .= "stroke=\"#000\" ";}
	if(isset($strokewidth)) {$svg .= "stroke-width=\"$strokewidth\" ";} else {$svg .= "stroke=\"1\" ";}
	if(isset($fill)) {$svg .= "fill=\"$fill\" ";} else {$svg .= "fill=\"none\" ";}
	if(isset($opacity)) {$svg .= "opacity=\"$opacity\" ";}
	// TO DO: Get angle using function here...
	if ($q[0] == $p[0]) {
		if($q[1] > $p[1]) { 
			$rotateAngleRad = 0;
		} else {
			$rotateAngleRad = pi();	
		}
	} else {
		$rotateAngleRad = pi()/2 - atan( (($q[1] - $p[1])*$yunitlength) / (($q[0] - $p[0])*$xunitlength) );
	}
	if($q[0] < $p[0]) {	
		$rotateAngleRad = pi() + $rotateAngleRad;
	} 
	$rotateAngleDeg = (180/pi())*$rotateAngleRad;
	if(!isset($triRotate)) {
		$triRotate = round($rotateAngleDeg);
	}
	$svg .= "transform = \"rotate($triRotate ".round($ox+$q[0]*$xunitlength)." ".round($height-$oy-$q[1]*$yunitlength).")\" ";
	$st = "d = \"M ".round($ox+$q[0]*$xunitlength)." ".round($height-$oy-$q[1]*$yunitlength).
			" L ".round($ox+$q[0]*$xunitlength-$triWidth/2)." ".round($height-$oy+$triHeight-$q[1]*$yunitlength).
			
			" L ".round($ox+$q[0]*$xunitlength)." ".round(-$triHeight/8+$height-$oy+$triHeight-$q[1]*$yunitlength).
			
			" L ".round($ox+$q[0]*$xunitlength+$triWidth/2)." ".round($height-$oy+$triHeight-$q[1]*$yunitlength).
			" Z\"";
	$svg .= $st;
	$svg .= ">";
	$svg .= "</path>\n";
	return $svg;
}

function axes($dx,$dy,$labels,$gdx,$gdy, $xAxisVbl, $yAxisVbl, $gridAttrs, $axesAttrs, $arrows, $brdParams) {	
	if(is_array($brdParams)) {
		foreach($brdParams as $key=>$val){
			${$key} = $val;
			//echo "$key=$val<br>";
		}	
	} else {
		echo "<div class=\"svgphpgrapherwarn\">There's a problem. Do you have the correct number of parameters for the <code>".__FUNCTION__."</code> function?</div>";
		return;
	}
	//echo $gridAttrs;
	//
	//echo "<p>gdx=$gdx, gdy=$gdy</p>";
	//echo "<p>dx=$dx, dy=$dy</p>";
	if(!is_string($dx)) {		
		$dx = ($dx==null?$xunitlength:$dx*$xunitlength);
	} else {
		//echo $dx; exit;
	}
	if(is_string($gdy) && $gdy != '') {
		$startVerticalGrids = $ox+2*$padding;
		$gdy = $gdy[1];
	} else {
		$startVerticalGrids = $height;
	}	
	if(strstr($labels, "00")) {
		$labelsStartX = 'start0';
		$labelsStartY = 'start0';
		$labels = str_replace("00", "", $labels);
	} else {
		$labelsStartX = '';
		$labelsStartY = '';			
	}
	if(strlen($dy) == 0){ $dy = 0; }
//echo "<p>**dx=$dx, dy=$dy</p>";	
	$dy = $dy*$yunitlength;
//echo "<p>dx=$dx, dy=$dy</p>";
	$fontsize = max(12, min($dx/2,$dy/2,16));
	$ticklength = $fontsize/4;
	$svg = '';
	// Grids
	if ($gdx!=0 && $dy != 0) {	
		$svg .= "<path id=\"grids-$boardID\" ";
		$gridAttrArr = explode(";", $gridAttrs);
		foreach($gridAttrArr as $gridAttPairs) {
			$gridAttPairsArr = explode(":", trim($gridAttPairs));
			foreach($gridAttPairsArr as $key=>$val){
				${$key} = $val;			
			}
			$thisKey = str_replace("-", "", $gridAttPairsArr[0]);
			$$thisKey = $gridAttPairsArr[1];
			//echo "grids: $thisKey=$gridAttPairsArr[1]<br>";
		}
		if(isset($stroke)) {$svg .= "stroke=\"$stroke\" ";} else {$svg .= "stroke=\"#000\" ";}
		if(isset($strokewidth)) {$svg .= "stroke-width=\"$strokewidth\" ";} else {$svg .= "stroke=\"1\" ";}
		if(isset($opacity)) {$svg .= "opacity=\"$opacity\" ";}
		if(isset($strokedasharray)) {$svg .= "stroke-dasharray=\"$strokedasharray\" ";}	
		if(isset($shaperendering)) {$svg .= "shape-rendering=\"$shaperendering\" ";}
		$gdx = (is_string($gdx)?$dx:$gdx*$xunitlength);
		$gdy = ($gdy==null?$dy:$gdy*$yunitlength);
		$st="";	
		
		$ldx = $dx/$xunitlength;

//echo "$ox, $dx, $dy, $labels, $gdx, $gdy<br>";
		
		// Positive vertical grids	(right side)				
		if($xmax > 0) {		
			if($ox<0) {
				$xStart = $padding;
			} else {
				$xStart = $ox + $gdx;				
			}
//echo "$ox :: $xStart :: $xmax :: $gdx :: ".($width-0.99*$padding). " :: $height :: $oy";			
			for ($x = $xStart; $x<$width-0.99*$padding; $x = $x+$gdx) {		
			  // Above x-axis
			  $st .= " M".round($x).",0 ".round($x).",".min($height, round($height - $oy));
			  // Below x-axis
			  if($labelsStartX != 'start0' && $oy > 0) {
//echo "$x<br>" . ($x - $ox)%$dx . "<br>";		
					if( ($x - $ox)%$dx == 0 ) {
						$gridStop = 0;
					} else {
						$gridStop = 0;
					}
		  
					$st .= " M".round($x).",".round($height - $oy + $gridStop)." ".round($x).",".round($startVerticalGrids);
			  }
			}		
		}

		// Negative vertical grids	(left side)  

			for ($x = $ox-$gdx; $x>0.95*$padding; $x = $x-$gdx) {
				
			  if($x < $width) {			  
				  // Above x-axis
				  if($height - $oy > 0) {
					  $st .= " M".round($x).",0 ".round($x).",".round($height - $oy);
				  }
				  // Below x-axis
				  if($oy < $height) {
					  $startVerticalGrids = $height-$oy;
					  $endVerticalGrids = $height;
					} else {
						$startVerticalGrids = 0;
						$endVerticalGrids = $height;
					}
//echo "x=$x, gdx=$gdx<br>**".($ox - $gdx - $x).", $dx<br>";					
					if( ($ox - $gdx - $x)%($dx) == 0 ) {
						$gridStop = 0;
					} else {
						$gridStop = 0;
					}					
					//$gridStop = 20;
					$st .= " M".round($x).",".($endVerticalGrids)." ".round($x).",".round($startVerticalGrids+$gridStop);			  
			  }
			}

		
		// Horizontal grid, positive side (top)
		
//echo "$gdy :: ".($height-max($oy,$ymin)-$gdy). " :: ".(0.99*$padding). " :: $height :: $oy :: ox=$ox :: $width :: $oy, $ymin\n";

 
		if( $oy < 0 ) {
			$yStart = $height-$padding;
		} else {
			$yStart = $height-max($oy,$ymin)-$gdy;
		}
		for ($y = $yStart; $y>0.99*$padding; $y = $y-$gdy) {
//echo "$y &&& $ymin\n";

		  // NEED THIS if?????
//		  if($y > $ymin) {
			// Left of y-axis
			if($ox>0 && $labelsStartX != 'start0') {
				$st .= " M0,".round($y)." ".min($width,round($ox)).",".round($y);
			}
			// Right of y-axis
			if($ox<$width) {
//echo "$y\n";				
				$st .= " M".max(0,round($ox)).",".round($y)." ".round($width).",".round($y);
			}
//		  }


		}
		
	   // Horizontal grid, negative side (bottom)
		for ($y = $height-$oy; $y<$height-0.95*$padding; $y = $y+$gdy) {
			if($y > 0) {
				// Left of y-axis
				if(min($width,round($ox)) > 0) {
					if($labelsStartX == 'start0') {
						$axisStart = $ox;
					} else {
						$axisStart = 0;
					}					
					
					$st .= " M$axisStart,".round($y)." ".min($width,round($ox)).",".round($y);
				}
				// Right of y-axis				
				if($ox < $width) {
					$st .= " M".max(0,round($ox)).",".round($y)." ".round($width).",".round($y);
				}
			}
		}
		$svg .= "d = \"$st\"";		
		$svg .= ">";
		$svg .= "</path>\n";
	}
	// Axes
	$svg .= "<path ";
	$svg .= 'id="axes-'.$boardID.'" ';	
	$axesAttrArr = explode(";", trim($axesAttrs, ";"));
	foreach($axesAttrArr as $axesAttPairs) {
		$axesAttPairsArr = explode(":", trim($axesAttPairs));
		$svg .= "$axesAttPairsArr[0]=\"$axesAttPairsArr[1]\" ";		  
	} 	
	$st="";
	if($dy != 0 && $ox > 0 && $ox < $width) { //
		if($labelsStartY == 'start0') {
			$axisEnd = $height - $oy;
		} else {
			$axisEnd = $height;
		}	
		$st.=" M".round($ox).",0 ".round($ox).",".round($axisEnd);  // y-axis grid line
	}
	if($oy < $height) {
		if($labelsStartX == 'start0') {
			$axisStart = $ox;
		} else {
			$axisStart = 0;
		}
		$st.="M$axisStart,".round(($height-$oy))." ".round($width).",".round(($height-$oy));  // x-axis grid line	
	}
	// Ticks on positive x-axis
	//if($ox < $width && $ox > 0) {
	if($ox < $width) {
//		for ($x = max($xmin,$ldx); $x<=$xmax; $x = $x+$ldx) {
		//for ($x = max($xmin/$xunitlength,$ox+$dx); $x<$width; $x = $x+$dx) {		
		for ($x = max($ox+$xmin*$xunitlength,$ox+$dx); $x<$width-0.99*$padding; $x = $x+$dx) {	
//echo "$x, $ox, ".$xmin*$xunitlength."<br>";		
			if($x>0) {
//echo "add st<br>";				
				$st .= " M".round($x).",".round(($height-$oy + $ticklength))." ".round($x).",".round(($height-$oy-$ticklength));
			}
		}
	}	
	// Ticks on negative x-axis
	for ($x = min($ox+$xmax*$xunitlength,$ox); $x>0.9*$padding; $x = $x-$dx) {
//echo "$x, $ox, ".$xmax*$xunitlength."<br>";		
		if($oy < $height && $x<$width) {
//echo "add st<br>";			
			$st .= " M".round($x).",".round(($height-$oy+$ticklength))." ".round($x).",".round(($height-$oy-$ticklength));
		}
	}
	if($dy != '' && $ox > 0 && $ox < $width) {
		// Ticks on positive y-axis
		for ($y = $height-$oy-$dy; $y>0.99*$padding; $y -= $dy) {
//echo "$y<br>";			
			$st .= " M".round($ox+$ticklength).",".round($y)." ".round($ox-$ticklength).",".$y;
		}
		// Ticks on negative y-axis
		for ($y = $height-$oy+$dy; $y<$height-0.9*$padding; $y += $dy) {
			$st .= " M".round($ox+$ticklength).",".$y." ".round($ox-$ticklength).",".round($y);
		}
	}
	$svg .= "d = \"$st\"";
	$svg .= ">";
	$svg .= "</path>\n";
	
	// Axes labels
	if ($labels!=null) {

		
		$labelsArr = explode(",", $labels);
//echo $labelsArr[1]; exit;		
		$ldx = $dx/$xunitlength;
		$ldy = $dy/$yunitlength;
		$lx = ($xmin>0 || $xmax<0?$xmin:0);
		$ly = ($ymin>0 || $ymax<0?$ymin:0);
//echo "$ly, $ymin, $ymax<br>";		
		// ORIGINAL : $lxp = ($ly==0?"below":"above");
		$lxp = "below";
		$lyp = ($lx==0?"left":"right");
		$ddx = floor(1.1-log($ldx)/log(10))+2;
		$ddy = floor(1.1-log($ldy)/log(10))+2;
//echo "$ddx, $ddy<br>";		
		//$svg .= '<g class="intmath">';
		$axisClass = 'intmath';
		if(strstr($svg, "grids")) {
			$axisTxtAttrs = 'gridsAru';
			
 			
		} else {
			$axisTxtAttrs = '';	
		}
//print_r($labelsArr);		
		// Positive x-axis labels
		for ($x = max($xmin,$ldx); $x<=$xmax; $x = $x+$ldx) {
			if(strlen($labelsArr[0]) > 0 && count($labelsArr)>1 && $labelsArr[0] != "numbers") {
//echo "$x, ".$x/pi();				
				if( abs($x/pi() - 1)>0.01) {
					$piMult = round($x/pi(),$ddx)."&#x3c0;";
				} else {
					$piMult = "&#x3c0;";
				}
//echo $piMult;	
				$p = [$x-(5+strlen(round($x, $ddx)))/$xunitlength,-20/$yunitlength]; 
				$q = [$x+(5+strlen(round($x, $ddx)))/$xunitlength,-4/$yunitlength];
				$attrs = "fill:#fff";
				$svg .= rect($p,$q,$attrs,$brdParams);
				
				//if($x/pi() != 1) {$piMult = round($x/pi(),$ddx)."&".$labelsArr[0].";";} else {$piMult = "&".$labelsArr[0].";";}
				$svg .= text([$x,$ly],$piMult,$lxp, $axisClass, $axisTxtAttrs,$brdParams);  	  	
			} else {
				$p = [$x-(5+strlen(round($x, $ddx)))/$xunitlength,-20/$yunitlength]; 
				$q = [$x+(5+strlen(round($x, $ddx)))/$xunitlength,-4/$yunitlength];
				$attrs = "fill:#fff";
				$svg .= rect($p,$q,$attrs,$brdParams);
				$svg .= text([$x,$ly],round($x,$ddx),$lxp, $axisClass, $axisTxtAttrs,$brdParams);  // point, string, position, class, attrs, brdParams		  
			}
		}
		if($dy == '' && $xmax >= 0) {  // For inequalities case (no y-axis) to include 0
			$strt = 0;
		} else {
			if($xmax >= 0) {
				$strt = -$ldx;
			} else {
				$strt = $xmax;
			}
		}		
		$axisClass = 'intmath';
		// Negative x-axis labels		
		for ($x = $strt; $x>=$xmin; $x = $x-$ldx) {
			//$svg .= text([$x,$ly],round($x,$ddx),$lxp, $axisClass, $axisTxtAttrs,$brdParams);
			
			if(strlen($labelsArr[0]) > 0 && count($labelsArr)>1 && $labelsArr[0] != "numbers") {
				if( abs($x/pi() + 1) > 0.01) {$piMult = round($x/pi(),$ddx)."&#x3c0;";} else {$piMult = "&#x2212;&#x3c0;";}
				$p = [$x-(5+strlen(round($x, $ddx)))/$xunitlength,-20/$yunitlength]; 
				$q = [$x+(5+strlen(round($x, $ddx)))/$xunitlength,-4/$yunitlength];
				$attrs = "fill:#fff";
				$svg .= rect($p,$q,$attrs,$brdParams);				
				$svg .= text([$x,$ly],$piMult,$lxp, $axisClass, $axisTxtAttrs,$brdParams);  // point, string, position, class, attrs, brdParams		  	
			} else {
				$p = [$x-(5+strlen(round($x, $ddx)))/$xunitlength,-20/$yunitlength]; 
				$q = [$x+(5+strlen(round($x, $ddx)))/$xunitlength,-4/$yunitlength];
				$attrs = "fill:#fff";
				$svg .= rect($p,$q,$attrs,$brdParams);
				
				$svg .= text([$x,$ly],round($x,$ddx),$lxp, $axisClass, $axisTxtAttrs,$brdParams);  // point, string, position, class, attrs, brdParams		  
			}			
			
		}
		
		/*if( $oy < 0 ) {
			$labelsFudgeLeft = $lx;//-7/$xunitlength;
//echo "$oy, $labelsFudgeLeft<br>";			
		} else {
			$labelsFudgeLeft = $lx;
		}*/
		
		$labelsFudgeLeft = $lx;
		
		if($dy != 0 ) {
			// Positive y-axis labels
			for ($y = $ldy; $y<=$ymax; $y = $y+$ldy) {
				if($y > $ymin) {				
					if(count($labelsArr)>1 && strlen($labelsArr[1]) > 0 && $labelsArr[1] != "numbers") {
						if( abs($y/pi() - 1) > 0.01 ) {$piMult = round($y/pi(),$ddy)."&#x3c0;";} else {$piMult = "&#x3c0;";}
						$p = [$lx-20/$xunitlength,$y-8/$yunitlength]; 
						$q = [$lx-5/$xunitlength,$y+8/$yunitlength];
						$attrs = "fill:#fff";
						$svg .= rect($p,$q,$attrs,$brdParams);						
						$svg .= text([$lx,$y],$piMult,$lyp, $axisClass, $axisTxtAttrs,$brdParams);  	  	
					} else {						
						$p = [$lx-(5+strlen(round($y, $ddy))*10)/$xunitlength,$y-8/$yunitlength]; 
						$q = [$lx-5/$xunitlength,$y+8/$yunitlength];
						$attrs = "fill:#fff";
						$svg .= rect($p,$q,$attrs,$brdParams);
						//
						// ORIGINAL: $svg .= text([$lx,$y],round($y, $ddy),$lyp, $axisClass, $axisTxtAttrs,$brdParams);  
						$svg .= text([$labelsFudgeLeft,$y],round($y, $ddy),$lyp, $axisClass, $axisTxtAttrs,$brdParams);  
					}
				}
			}
			// Negative y-axis labels
			for ($y = -$ldy; $ymin<=$y; $y = $y-$ldy) {
				if($y <= $ymax) {
					if(count($labelsArr)>1 && strlen($labelsArr[1]) > 0 && $labelsArr[1] != "numbers") {
						if(abs($y/pi()) != 1) {$piMult = round($y/pi(),$ddy)."&#x3c0;";} else {$piMult = "&#x2212;&#x3c0;";}					
						$svg .= text([$lx,$y],$piMult,$lyp, $axisClass, $axisTxtAttrs,$brdParams);  	  	
					} else {
						$p = [$lx-(5+strlen(round($y, $ddy))*10)/$xunitlength,$y-8/$yunitlength]; $q = [$lx-5/$xunitlength,$y+8/$yunitlength];
						$attrs = "fill:#fff";
						$svg .= rect($p,$q,$attrs,$brdParams);						
						$svg .= text([$lx,$y],round($y, $ddy),$lyp, $axisClass, $axisTxtAttrs,$brdParams);  
					}
				}
			}
		}		
	} 
	// Axis variable labels
	$attrs = '';
	$axisVblClass = 'intmathItalic';
	//echo "ox=$ox, oy=$oy<br>";	
	if(strlen($xAxisVbl) > 0 && $oy<$height) {
		$svg .= text([$xmax+($padding+6)/($xunitlength),14/$yunitlength],$xAxisVbl,"left", $axisVblClass, $attrs,$brdParams);
	}
	if($dy !== '' && strlen($yAxisVbl) > 0 && $ox > 0 &&  $ox < $width) {
//echo ($ymax+$padding/(2*$yunitlength) + 2/$yunitlength);
//echo "<br>$ymax + $padding / (2*$yunitlength) + 2/$yunitlength)";		
		$svg .= text([-4/$xunitlength,$ymax+$padding/(2*$yunitlength) + 2/$yunitlength],$yAxisVbl,"rightAx", $axisVblClass, $attrs,$brdParams);
	}
	// Axis arrows
	if($arrows == 1) {		
		$arrAttrs = 'triWidth:8; triHeight:14; stroke:#555; stroke-width:1; fill:#555;';
		if($oy < $height) {
			$svg .= arrowHead([-2000000000,0], [$xmax+$padding/$xunitlength, 0],  $arrAttrs,$brdParams);   //$p, $q, $attrs,$brdParams
		}
		if($dy != 0 && $ox > 0 && $ox < $width) {
			$svg .= arrowHead([0, $ymin], [0, $ymax + ($padding)/$yunitlength], $arrAttrs, $brdParams);
		}
	}
	return $svg;
}

function circle($center,$radius,$id, $attrs, $brdParams) {	
	if(is_array($brdParams)) {
		foreach($brdParams as $key=>$val){
			${$key} = $val;
			//echo "$key=$val<br>";
		}	
	} else {
		echo "<div class=\"svgphpgrapherwarn\">There's a problem. Do you have the correct number of parameters for the <code>".__FUNCTION__."</code> function?</div>";
		return;
	}
	// When axes are not equal scaled, should look like an ellipse...
	return ellipse($center,$radius,$radius, $id, $attrs, $brdParams);
}

function dot($center, $radius, $attrs, $brdParams) { // $center in x-y coords, $radius in pixels
	if(is_array($brdParams)) {
		foreach($brdParams as $key=>$val){
			${$key} = $val;
			//echo "$key=$val<br>";
		}	
	} else {
		echo "<div class=\"svgphpgrapherwarn\">There's a problem. Do you have the correct number of parameters for the <code>".__FUNCTION__."</code> function?</div>";
		return;
	}
//echo $axesType;	
  $svg = "<circle ";
  if($axesType == "loglin" || $axesType == "linlin") {
	  $svg .= "cx=\"".round($center[0]*$xunitlength+$ox)."\" ";
  } else {  // loglog or linlog cases  
		$logBase = 10;
		$num_x_sections = log($xmax/$xmin)/log($logBase) ;
		$widthSection = ($width-2*$padding)/$num_x_sections;
		$x_pixels = (log($center[0])-log($xmin))*($width)/($num_x_sections*log($logBase));  
		$svg .= "cx=\"". ($x_pixels + $padding*(1-2*$x_pixels/$width)) ."\" ";   
  }
  if($axesType == "loglin" || $axesType == "loglog") {
		$logBase = 10;
		$num_y_sections = log($ymax/$ymin)/log($logBase) ;
		$heightSection = ($height-2*$padding)/$num_y_sections;
		$y_pixels = (log($center[1])-log($ymin))*($height)/($num_y_sections*log($logBase));
      $svg .= "cy=\"". ( ($height - $padding*(1-2*$y_pixels/$height)) -  $y_pixels) ."\" ";  
  } else {  
		$svg .= "cy=\"".round($height - $center[1]*$yunitlength - $oy)."\" ";
  }
  $svg .= "r=\"".($radius)."\" ";
  $attrArr = explode(";", $attrs);
  if(substr_count($attrs, ";") > 0) {
	  foreach($attrArr as $attPairs) {
		  $attPairsArr = explode(":", trim($attPairs));		  
		  if($attPairsArr[0] != 'radius') {
				$svg .= "$attPairsArr[0]=\"$attPairsArr[1]\" ";		  
		  }
	  }
  } 
  $svg .= ">";
  $svg .= "</circle>\n"; 
  return $svg; 
}

function dotSegArrow($p, $q, $dotAttrs, $segAttrs, $arrAttrs,$brdParams) {
	if(is_array($brdParams)) {
		foreach($brdParams as $key=>$val){
			${$key} = $val;
			//echo "$key=$val<br>";
		}	
	} else {
		echo "<div class=\"svgphpgrapherwarn\">There's a problem. Do you have the correct number of parameters for the <code>".__FUNCTION__."</code> function?</div>";
		return;
	}	
	$rotateAngleRad = getRotAteangle($p, $q, $xunitlength, $yunitlength);
	$rotateAngleDeg = (180/pi())*$rotateAngleRad;
	if(!isset($triRotate)) {
		$triRotate = $rotateAngleDeg;
	}
	$svg = '';	
	$attrs = trim($dotAttrs, ";");  // Note dot
	$attrArr = explode(";", $attrs);
	$attrArrVals = array();
	foreach($attrArr as $attPairs) {
		$attPairsArr = explode(":", trim($attPairs));
		foreach($attPairsArr as $key=>$val){
			${$key} = $val;			
		}
		$thisKey = str_replace("-", "", $attPairsArr[0]);
		$$thisKey = $attPairsArr[1];
	}	
	$svg .= dot([$p[0], $p[1]], $radius, $dotAttrs, $brdParams);
	//
	$attrs = trim($arrAttrs, ";");  // Note arr
	$attrArr = explode(";", $attrs);
	$attrArrVals = array();
	foreach($attrArr as $attPairs) {
		$attPairsArr = explode(":", trim($attPairs));
		foreach($attPairsArr as $key=>$val){
			${$key} = $val;			
		}
		$thisKey = str_replace("-", "", $attPairsArr[0]);
		$$thisKey = $attPairsArr[1];
	}
	if( ($q[0] == $xmin && $q[1] == 0) || ($q[0] == $xmax && $q[1] == 0) ) {
		$includePadding = $padding;
		if($q[0] == $xmin) {
			$includePadding = -$padding;
		}
	} else {
		$includePadding = 0;
	}
	$newQ0 = round($q[0] - (1.5*($strokewidth)*cos($rotateAngleRad) - $includePadding)/$xunitlength, 2);
	$newQ1 = round($q[1] + 1.5*($strokewidth)*sin($rotateAngleRad)/$yunitlength, 2);	
	$svg .= arrowHead ($p, [$newQ0, $newQ1], $arrAttrs,$brdParams);
	//
	$newP0 = round($p[0] - ((-$radius)*cos($rotateAngleRad))/$xunitlength, 2);
	$newP1 = round($p[1] - ($radius)*sin($rotateAngleRad)/$yunitlength, 2);	
	$newQ0 = round($q[0] - (($triHeight)*cos($rotateAngleRad) - $includePadding)/$xunitlength, 3);
	$newQ1 = round($q[1] + ($triHeight)*sin($rotateAngleRad)/$yunitlength, 3);	
	$svg .= segment([$newP0,$newP1], [$newQ0,   $newQ1],  $segAttrs,$brdParams);	
	return $svg;	
}

function dotSegDot($p, $q, $dot0Attrs,$segAttrs,$dot1Attrs, $brdParams) {
	if(is_array($brdParams)) {
		foreach($brdParams as $key=>$val){
			${$key} = $val;
			//echo "$key=$val<br>";
		}	
	} else {
		echo "<div class=\"svgphpgrapherwarn\">There's a problem. Do you have the correct number of parameters for the <code>".__FUNCTION__."</code> function?</div>";
		return;
	}	
	$rotateAngleRad = getRotAteangle($p, $q, $xunitlength, $yunitlength);
	$rotateAngleDeg = (180/pi())*$rotateAngleRad;
	if(!isset($triRotate)) {
		$triRotate = $rotateAngleDeg;
	}
	$svg = '';	
	$attrs = trim($dot0Attrs, ";");  // Note dot0
	$attrArr = explode(";", $attrs);
	$attrArrVals = array();
	foreach($attrArr as $attPairs) {
		$attPairsArr = explode(":", trim($attPairs));
		foreach($attPairsArr as $key=>$val){
			${$key} = $val;			
		}
		$thisKey = str_replace("-", "", $attPairsArr[0]);
		$$thisKey = $attPairsArr[1];
	}	
	$svg .= dot([$p[0], $p[1]], $radius, $dot0Attrs, $brdParams);
	$radius0 = $radius;
	//
	$attrs = trim($dot1Attrs, ";");  // Note dot1
	$attrArr = explode(";", $attrs);
	$attrArrVals = array();
	foreach($attrArr as $attPairs) {
		$attPairsArr = explode(":", trim($attPairs));
		foreach($attPairsArr as $key=>$val){
			${$key} = $val;			
		}
		$thisKey = str_replace("-", "", $attPairsArr[0]);
		$$thisKey = $attPairsArr[1];
	}	
	$svg .= dot([$q[0], $q[1]], $radius, $dot1Attrs, $brdParams);	
	$radius1 = $radius;	
	//
	$newP0 = $p[0] + ($radius0*cos($rotateAngleRad))/$xunitlength;
	$newP1 = $p[1] - ($radius0*sin($rotateAngleRad))/$yunitlength;	
	$newQ0 = $q[0] - ($radius1*cos($rotateAngleRad))/$xunitlength;
	$newQ1 = $q[1] + ($radius1*sin($rotateAngleRad))/$yunitlength;
	$svg .= segment([$newP0,$newP1], [$newQ0,   $newQ1],  $segAttrs,$brdParams);	
	return $svg;	
}

function ellipse($center,$rx,$ry,$id, $attrs, $brdParams) {
	if(is_array($brdParams)) {
		foreach($brdParams as $key=>$val){
			${$key} = $val;
			//echo "$key=$val<br>";
		}	
	} else {
		echo "<div class=\"svgphpgrapherwarn\">There's a problem. Do you have the correct number of parameters for the <code>".__FUNCTION__."</code> function?</div>";
		return;
	}
	$svg = "<ellipse ";
	$attrArr = explode(";", trim($attrs, ";"));
	foreach($attrArr as $attPairs) {
	  $attPairsArr = explode(":", $attPairs);
	  $svg .= "$attPairsArr[0]=\"$attPairsArr[1]\" ";		  
	} 
	$svg .= "cx = \"".round($center[0]*$xunitlength+$ox, 3)."\" ";
	$svg .= "cy = \"".round($height-$center[1]*$yunitlength-$oy)."\" ";
	$svg .= "rx = \"".round($rx*$xunitlength)."\" ";
	$svg .= "ry = \"".round($ry*$yunitlength)."\" ";
	$svg .= ">";
	$svg .= "</ellipse>\n";	
	return $svg;
}

function ellipticArc($start,$end, $rx,$ry, $xAaxisRotation, $largeArcFlag, $sweepFlag, $attrs, $brdParams) {
	if(is_array($brdParams)) {
		foreach($brdParams as $key=>$val){
			${$key} = $val;
			//echo "$key=$val<br>";
		}	
	} else {
		echo "<div class=\"svgphpgrapherwarn\">There's a problem. Do you have the correct number of parameters for the <code>".__FUNCTION__."</code> function?</div>";
		return;
	}

	$svg = "<path ";
	$attrArr = explode(";", $attrs);
	foreach($attrArr as $attPairs) {
	  $attPairsArr = explode(":", trim($attPairs));
	  //if(strlen($attPairsArr[0]>0) && strlen($attPairsArr[1]>0) ) {
		  $svg .= "$attPairsArr[0]=\"$attPairsArr[1]\" ";		  
	  //}
	}
	$st = "d = \"M";
	$st .= ($start[0]*$xunitlength+$ox).",".
			 ($height-$start[1]*$yunitlength-$oy)." A".$rx*$xunitlength.",".
			  $ry*$yunitlength." 0 $largeArcFlag,$sweepFlag ".($end[0]*$xunitlength+$ox).",".
			 ($height-$end[1]*$yunitlength-$oy);
	$svg .= $st."\"";
	$svg .= ">";
	$svg .= "</path>\n";	
	return $svg;   
}

function line($p,$q,$attrs,$brdParams) {
	if(is_array($brdParams)) {
		foreach($brdParams as $key=>$val){
			${$key} = $val;
			//echo "$key=$val<br>";
		}	
	} else {
		echo "<div class=\"svgphpgrapherwarn\">There's a problem. Do you have the correct number of parameters for the <code>".__FUNCTION__."</code> function?</div>";
		return;
	}
	if($p[0] == $q[0]) {
		$svg = segment([$p[0],$ymin-$padding/$yunitlength], [$q[0],$ymax+$padding/$yunitlength], $attrs,$brdParams);
	} else {
		$slope = (($q[1] - $p[1])) / (($q[0] - $p[0]));
		$fun = "$slope(x-$p[0]) + $p[1]";	
		$svg = plot($fun,'', '',10, $attrs,$brdParams);
	}
	return $svg;
}

function tangent($fun,$x,$attrs,$brdParams) {
	if(is_array($brdParams)) {
		foreach($brdParams as $key=>$val){
			${$key} = $val;
			//echo "$key=$val<br>";
		}	
	} else {
		echo "<div class=\"svgphpgrapherwarn\">There's a problem. Do you have the correct number of parameters for the <code>".__FUNCTION__."</code> function?</div>";
		return;
	}
	$m = new EvalMath;
	if ($m->evaluate('y(x) = '.$fun) ) {
			/*for ($t = $min-$lessPadding; $t <= $max+$morePadding; $t += $inc) {
				if(abs($t) < 0.0001) {  // evalMath class didn't cope if value very close to 0
					$tNew = 0;
				} else {
					$tNew = $t;
				}*/
		$h = 0.001;
		$y0 = $m->e("y($x)");
		$y1 = $m->e("y($x+$h)");		
	}
	$slope = ($y1 - $y0)/$h;
	$lineFn = "$slope(x-$x) + $y0";
	$svg = plot($lineFn,'', '',30, $attrs,$brdParams);
	//echo $lineFn;
	//}
	return $svg;
}

function logaxes($dx,$dy,$labels,$gdx,$gdy, $xAxisVbl, $yAxisVbl, $gridAttrs, $axesAttrs, $arrows, $brdParams) {
	if(is_array($brdParams)) {
		foreach($brdParams as $key=>$val){
			${$key} = $val;
			//echo "$key=$val<br>";
		}	
	} else {
		echo "<p class=\"svgphpgrapherwarn\">There's a problem. Do you have the correct number of parameters for the <code>".__FUNCTION__."</code> function?</p>";
		return;
	}
	$svg = '';
	$gridD = '';
	$yaxisTxtLabs = '';
	$xaxisTxtLabs = '';
	$axesSt = '';
	$axesD = '';
	$logBase = 10;
	if($axesType == "loglin" || $axesType == "loglog") {
		$oy = $padding;
	}
	if($axesType == "linlog" || $axesType == "loglog") {
		$ox = $padding;
	}		
	$dx = ($dx==null?$xunitlength:$dx*$xunitlength);
	$dy = $dy*$yunitlength;
	$fontsize = max(12, min($dx/2,$dy/2,16));
	$ticklength = $fontsize/4;	
	///////////////////////////////////////////////////////////
	//
	// All grids and axes for log type
	//
	///////////////////////////////////////////////////////////
	if ($gdx!=0 && $dy != 0) {		
		$gdx = (is_string($gdx)?$dx:$gdx*$xunitlength);
		$gdy = ($gdy==null?$dy:$gdy*$yunitlength);
		// Horizontal grids when log y-axis		
		if($axesType == "loglin" || $axesType == "loglog") {
			$pixRem = 1000;
			$num_y_sections = log($ymax/$ymin)/log($logBase) ;			
			
			for($k = $num_y_sections; $k>-1; $k--) {
				$yTicks = $padding+$k*($height-2*$padding)/$num_y_sections;
				// x-axis
				if($axesType == "loglog") {
					$axesD .= " M$padding,".$yTicks." ".round($width).",".$yTicks;
					$yaxisTxtTxt = ($ymin * pow(10,$num_y_sections - $k));
					//
					$yaxisTxtLabs .= '<text x="'.($ox-20).'" y="'.round($yTicks+$fontsize/2-2).'" class="intmath" text-anchor="end">10<sup>'.round(log($yaxisTxtTxt)/log(10)).'</sup></text>'."\n";					
				} else {
					$axesD .= " M0,".$yTicks." ".round($width).",".$yTicks;	
				}
				for($b = $logBase; $b>0; $b--) {
					if($k > 0) {
						$logTicks = $yTicks  - ($yTicks-$padding)*log($b)/($k*log($logBase)); //$yTicks*(1 + pow(10,-$b));						
					} else {
						$logTicks = $yTicks;
					}					
					// Horizontal grids left of y-axis
					if($axesType == "loglin") {
						$gridD .= " M0,".round($logTicks)." ".round($ox).",".round($logTicks);
					}
					// Horizontal grids right of y-axis
					$gridD .= " M".round($ox).",".round($logTicks)." ".round($width).",".round($logTicks);					
					// Positive y-axis labels
					$class= 'intmath';
					$axisTxtAttrs = '';
					if($axesType == "loglin") {
						$pixDiff = ($logTicks+$fontsize/2-1) - $pixRem;
						if($pixDiff > $fontsize) {
							$yaxisTxtLabs .= '<text x="'.($ox-7).'" y="'.($logTicks+$fontsize/2).'" class="intmath" text-anchor="end">'.($ymin * $b * pow(10,$num_y_sections - $k)).'</text>'."\n";
						}		
					} 
					$pixRem = $logTicks+$fontsize/2-1;
				}
			}
			if($axesType == "loglin") {
				// Last y-axis one
				$yaxisTxtLabs .= '<text x="'.($ox-7).'" y="'.($padding+6).'" class="intmath" text-anchor="end">'.($ymax).'</text>'."\n";
			}			
		}
		// Horizontal grids when linear y-axis	
		if($axesType == "linlog") {
			if(is_string($gdy) && $gdy != '') {
				$startVerticalGrids = $ox+2*$padding;
				$gdy = $gdy[1];
			} else {
				$startVerticalGrids = $height;
			}
			// Horizontal grid, positive side
			for ($y = $height-max($oy,$ymin)-$gdy; $y>$gdy; $y = $y-$gdy) {
			  if($y > $ymin) {
				$gridD .= " M0,".round($y)." ".round($width).",".round($y);
			  }
			}
			// Horizontal grid, negative side
			for ($y = $height-$oy; $y<$height-$gdy; $y = $y+$gdy) {
				if($y > 0 && $startVerticalGrids == $height) {
					$gridD .= " M0,".round($y)." ".round($width).",".round($y);
				}
			}		
		}
		// Vertical grids when log x-axis
		if($axesType == "linlog" || $axesType == "loglog") {
			$pixRem = 1000;
			$num_x_sections = log($xmax/$xmin)/log($logBase);
			$sectionWidth = ($width-2*$padding)/$num_x_sections;		
			for($k = $num_x_sections; $k>-1; $k--) {
				$xTicks = $padding+$k*($width-2*$padding)/$num_x_sections;
				// x-axis
				$axesD .= " M".$xTicks.",0 ".$xTicks.",".round($height-$padding);
				$xaxisTxtTxt = $xmin * pow(10,$k);
				$xaxisTxtLabs .= '<text x="'.round($xTicks).'" y="'.round($height -$padding+15).'" class="intmath" text-anchor="middle">'.($xaxisTxtTxt).'</text>'."\n";
				for($b = 1; $b<$logBase; $b++) {	
					if($k > 0) {
						$logTicks = $xTicks - $sectionWidth + ($xTicks-$padding)*log($b)/($k*log($logBase));
					}
					$gridD .= " M".round($logTicks).",0 ".round($logTicks).",".round($height-$padding);
					$pixRem = $logTicks+$fontsize/2-1;
				}
			}		
		}
		// Vertical grids when linear x-axis		
		if($axesType == "loglin") {		
			// Positive vertical grids	
			for ($x = max($xmin,$ox); $x<$width; $x = $x+$gdx) {
			  $gridD .= " M".round($x).",0 ".round($x).",".round($height-$padding);	
			}
			// Negative vertical grids	  
			for ($x = $ox-$gdx; $x>0; $x = $x-$gdx) {
			  if($x < $width) {
				  $gridD .= " M".round($x).",0 ".round($x).",".round($height-$padding);
			  }
			}
			$ldx = $dx/$xunitlength;
			$ldy = $dy/$yunitlength;
			$lx = ($xmin>0 || $xmax<0?$xmin:0);		
			$ly = ($ymin>0 || $ymax<0?$ymin:0);
			$lxp = 'below';
			$lyp = ($lx==0?"left":"right");
			$ddx = floor(1.1-log($ldx)/log(10))+2;
			$ddy = floor(1.1-log($ldy)/log(10))+2;			
			$axisClass = 'intmath';
			$axisTxtAttrs = '';
			if($axesType == "loglin") {
				// Positive x-axis labels - LINEAR case
				for ($x = max($xmin,$ldx); $x<=$xmax; $x = $x+$ldx) {
					$xaxisTxtLabs .= text([$x,$ly],round($x,$ddx),$lxp, $axisClass, $axisTxtAttrs,$brdParams);  // point, string, position, class, attrs, brdParams		  
				}	
				$strt = 0;				
				// Negative x-axis labels - LINEAR case
				for ($x = $strt; $xmin<=$x; $x = $x-$ldx) {	
					$svg .= text([$x,$ly],round($x,$ddx),$lxp, $axisClass, $axisTxtAttrs,$brdParams);
				}	
			}	
		}
		$svg .= "<path ";
		$svg .= 'id="grids-'.$boardID.'" ';
		$gridAttrArr = explode(";", $gridAttrs);
		foreach($gridAttrArr as $gridAttPairs) {
			$gridAttPairsArr = explode(":", trim($gridAttPairs));
			$svg .= "$gridAttPairsArr[0]=\"$gridAttPairsArr[1]\" ";		  
		}
		$svg .= "d = \"$gridD\"";
		$svg .= ">";
		$svg .= "</path>\n";	
	}
	///////////////////////////////////////////////////////////
	//
	// Axes and axes numbering (linlog only, as other 2 taken care of above)
	//
	///////////////////////////////////////////////////////////	
	if($axesType == "linlog") {
		$ldy = $dy/$yunitlength;
		$lx = ($xmin>0 || $xmax<0?$xmin:0);		
		$ly = ($ymin>0 || $ymax<0?$ymin:0);
		$lyp = ($lx==0?"left":"right");
		$ddy = floor(1.1-log($ldy)/log(10))+2;
		$axisClass = 'intmath';  // for now
		$axisTxtAttrs = ''; // for now
		if($dy != 0 ) {
			// Positive y-axis labels
			for ($y = 0; $y<=$ymax; $y = $y+$ldy) {
				if($y > $ymin) {
					$yaxisTxtLabs .= text([$lx,$y],round($y, $ddy),$lyp, $axisClass, $axisTxtAttrs,$brdParams);
				}
			}
			// Negative y-axis labels
			for ($y = -$ldy; $ymin<=$y; $y = $y-$ldy) {
				if($y <= $ymax) {
					$yaxisTxtLabs .= text([$lx,$y],round($y, $ddy),$lyp, $axisClass, $axisTxtAttrs,$brdParams);
				}
			}
		}
		$axesD .="M".round($ox).",".round($height-$oy)." ".round($width).",".round($height-$oy);  // x-axis grid line
	}
	if ($dx!=0 && $dy != 0) {
		$svg .= "<path ";
		$svg .= 'id="axes-'.$boardID.'" ';
		$axesAttrArr = explode(";", $axesAttrs);		
		foreach($axesAttrArr as $axesAttPairs) {
			$axesAttPairsArr = explode(":", trim($axesAttPairs));
			$svg .= "$axesAttPairsArr[0]=\"$axesAttPairsArr[1]\" ";		  
		} 
		$axesD .="M".round($ox).",0 ".round($ox).",".round($height-$padding);  // y-axis grid line
		$svg .= "d = \"$axesD\"";
		$svg .= ">";
		$svg .= "</path>\n";	
		$svg .= $yaxisTxtLabs;
		$svg .= $xaxisTxtLabs;
	}
	///////////////////////////////////////////////////////////
	//
	// Axis vbls
	//
	///////////////////////////////////////////////////////////	
	$attrs = '';
	$axisVblClass = 'intmathItalic';
	// y-axis
	if($axesType == "linlog") {
		$yVbl_xVal = $xmin-6/$xunitlength;
	} else {
		$yVbl_xVal = -4/$xunitlength;
	}	
	if($dy != 0 && strlen($yAxisVbl) > 0 ) {  
		$svg .= text([$yVbl_xVal, $ymax+$padding/(2*$yunitlength) + 2/$yunitlength],$yAxisVbl,"right", $axisVblClass, $attrs,$brdParams);
	}
	// x-axis
	if(strlen($xAxisVbl) > 0 && $ox > 0 && $ox < $width) {
		$svg .= text([$xmax+($padding+6)/($xunitlength),14/$yunitlength],$xAxisVbl,"left", $axisVblClass, $attrs,$brdParams);
	}
	///////////////////////////////////////////////////////////
	//
	// Axis arrows
	//
	///////////////////////////////////////////////////////////
	if($arrows == 1) {		
		$arrAttrs = 'triWidth:8; triHeight:12; stroke:#888; stroke-width:1; fill:#888;';
		// y-axis
		if($axesType == "linlog") {
			$yarrow_xVal = $xmin;
		} else {
			$yarrow_xVal = 0;
		}
		if($dy != 0 && $ox > 0 && $ox < $width) {
			$svg .= arrowHead([$yarrow_xVal, $ymin], [$yarrow_xVal, $ymax + ($padding)/$yunitlength], $arrAttrs, $brdParams);
		}
		// x-axis		
		if($oy < $height) {
			$svg .= arrowHead([0,0], [$xmax+$padding/$xunitlength, 0],  $arrAttrs,$brdParams);   //$p, $q, $attrs,$brdParams
		}
	}
	return $svg;
}

function path($plist,$id,$closed, $attrs,$brdParams ) {
	
	if(!isset($plist[0])) {
		echo "<div class=\"svgphpgrapherwarn\">There's a problem. The ".'$plist'." array is empty. Are your view dimensions, domain or range defined so the graph will appear on the board?</div>";
		return;
	}
	// For testing: 
	$ptsSum = 0; $minHoriz = 2000000000; $maxHoriz = -2000000000; $minVert = 2000000000; $maxVert = -2000000000; 
	//
	if(is_array($brdParams)) {
		foreach($brdParams as $key=>$val){
			${$key} = $val;
			//echo "$key=$val<br>\n";
		}	
	} else {
		echo "<div class=\"svgphpgrapherwarn\">There's a problem. Do you have the correct number of parameters for the <code>".__FUNCTION__."</code> function?</div>";
		return;
	}	
	if ($closed==null) $c="";
	$pathOpen = 0;
	$yNow = $plist[0][1];
	$st = '';
	$svg = '';
	for ($i=0; $i< count($plist); $i++) {
		if($axesType == "loglog") {
			$plistMax = $height;  // $plist is in pixels for loglog
		} else {
			$plistMax = $ymax + ($ymax - $ymin)/4;
		}
		if( $plist[$i][1] > $ymin - ($ymax - $ymin)/4 && $plist[$i][1] < $plistMax) {
			if ($pathOpen == 0) {
				$pathOpen = 1;
				$st .= "<path ";
				$attrs = trim($attrs, ";");
				$attrArr = explode(";", $attrs);
				if(substr_count($attrs, ";") > 0) {
					foreach($attrArr as $attPairs) {
						$attPairsArr = explode(":", trim($attPairs));
						if($attPairsArr[0] != "logType") {
							$st .= "$attPairsArr[0]=\"$attPairsArr[1]\" ";
						}
					}
				}
				$st .= "d = \"M";				
			}
			if($axesType == "loglog") { // supplied in PIXELS for loglog
				if($plist[$i][1] > -10 ) {
					$st .= round( $plist[$i][0],1).",".round( $plist[$i][1],1)." ";	
				}
			} else if($axesType == "linlog") { // supplied in cartesian for linlog
				if($plist[$i][1] > -10 ) {
					$st .= round( $plist[$i][0],1).",".round( ($height-$plist[$i][1]*$yunitlength-$oy),1)." ";	
				}
			} else {
				$st .= round(( $plist[$i][0]*$xunitlength+$ox),1).",".round( ($height-$plist[$i][1]*$yunitlength-$oy),1)." ";
			}			
			// Testing
			$ptsSum++;
			$minHoriz = min(round( $plist[$i][0]*$xunitlength+$ox, 2), $minHoriz); 
			$maxHoriz = max(round( $plist[$i][0]*$xunitlength+$ox, 2), $maxHoriz); 
			$minVert = min(round( $height-$plist[$i][1]*$yunitlength-$oy, 2), $minVert);
			$maxVert = max(round( $height-$plist[$i][1]*$yunitlength-$oy, 2), $maxVert); 
			//
			$yNow = $plist[$i][0];
		} else if($pathOpen == 1) {
			$pathOpen = 0;
			$st .= "\"";
			$st .= ">";
			$st .= "</path>\n";
			$svg .= $st;
			$st = '';
		}
	}
	if($pathOpen == 1) {
		$svg .= $st."\"";
		$svg .= ">";
		$svg .= "</path>\n";
	}
	return $svg;
}

function plot($fun,$x_min,$x_max,$points, $attrs,$brdParams) {
	// For testing: 
	$ptsSum = 0; $minHoriz = 2000000000; $maxHoriz = -2000000000; $minVert = 2000000000; $maxVert = -2000000000; 
	//
	if(is_array($brdParams)) {
		foreach($brdParams as $key=>$val){
			${$key} = $val;
			//echo "$key=$val<br>";
		}	
	} else {
		echo "<div class=\"svgphpgrapherwarn\">There's a problem. Do you have the correct number of parameters for the <code>".__FUNCTION__."</code> function?</div>";
		return;
	}
	$attrs = trim($attrs, ";");
	$attrArr = explode(";", $attrs);		
	if(substr_count($attrs, ";") > 0) {
		foreach($attrArr as $attPairs) {
			$attPairsArr = explode(":", trim($attPairs));
			if($attPairsArr[0] == "logType") {
				$logType = $attPairsArr[1];
				break;  // Leave the loop
			} else {
				$logType = "linear";
			}
		}
	}	
	$m = new EvalMath;
	$pth = array();
	$svg = '';
	// YYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYY
	// YYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYYY
	if(strstr($fun, "y")) {
		if($x_min==='' || $x_min == $ymin) {
			$min = $ymin - $padding/$yunitlength;
		} else {
			$min = $x_min;
		} 		
		if($x_max==='' || $x_max == $ymax) {
			$max = $ymax + $padding/$yunitlength;
		} else {			
			$max = $x_max;
		}
		if($x_min == $ymin /*|| $x_max == $xmax*/ ) {  // Note reversals
			$lessPadding = $padding/$yunitlength;
		} else {
			$lessPadding = 0;
		}
		if($x_max == $ymax) {  // Note reversals
			$morePadding = $padding/$yunitlength;
		} else {
			$morePadding = 0;
		}				
		$inc = $max-$min-0.000001*($max-$min);	
		$inc = ($points==null?$inc/200:$inc/$points);
		$incOrig = $inc;
		$doOnceL = 0; $doOnceR = 0; $wasAnumber = 0; $discRem = 0;				
		$fun = str_replace("y", "x", $fun);
		if ($m->evaluate('y(x) = '.$fun) ) {
			for ($t = $min-$lessPadding; $t <= $max+$morePadding; $t += $inc) {
				if(abs($t) < 0.0001) {  // evalMath class didn't cope if value very close to 0
					$tNew = 0;
				} else {
					$tNew = $t;
				}				
				$xVal = $m->e("y($tNew)");
				if(isset($xValRem)) {
					$dydx = ($xVal - $xValRem)*$yunitlength/($inc*$xunitlength);
					if(abs($dydx) > 5  && ($xVal > $ymin && $xVal < $ymax) ) {
						$inc = $incOrig/10;
					} else  {
						$inc = $incOrig;
					}
				}
				if ($xVal > $ymin-1.3*($ymax-$ymin) && $xVal < $xmax+0.3*($xmax-$xmin)) {
					// Needed to be changed from 0.4 to 1.3 for 2a-domain-and-range.php first graph
					// Original: if ($xVal > $ymin-0.4*($ymax-$ymin) && $xVal < $xmax+0.3*($xmax-$xmin)) {
					// Testing
					$ptsSum++;
					$minHoriz = min($t, $minHoriz); 
					$maxHoriz = max($t, $maxHoriz); 
					$minVert = min($xVal, $minVert);
					$maxVert = max($xVal, $maxVert); 			
					//
					array_push ($pth, [$xVal, $t]);
				}
				$xValRem = $xVal;				
			}
		}
	// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
	// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
	} else {		
		if($x_min==='' || $x_min == $xmin) {
			$min = $xmin-$padding/$xunitlength;
		} else {
			$min = $x_min;
		}
		if($x_max==='' || $x_max == $xmax) {
			$incBit = ($xmax - $xmin)/200;
			$max = $xmax + $padding/$xunitlength + $incBit;
		} else {
			$max = $x_max;
			$incBit = 0;
		}
		$inc = $max-$min-0.000001*($max-$min);
		$inc = ($points==null?$inc/200:$inc/$points);
		$incOrig = $inc;
		$doOnceL = 0; $doOnceR = 0; $wasAnumber = 0; $discRem = 0;
		if(strstr($fun, 't') && !strstr($fun, 'x')) {
			$LHS = 'y(t)';
		} else {
			$LHS = 'y(x)';
		}
		if ($m->evaluate($LHS .' = '.$fun) ) {	
			if($axesType == "loglin") { // Outputs in cartesian coords, not pixels
				$logBase = 10;
				$num_y_sections = log($ymax/$ymin)/log($logBase) ;				
				for ($t = $min; $t <= $max+$incBit; $t += $inc) {	
					if(abs($t) < 0.0001) {  // evalMath class didn't cope if value very close to 0
						$tNew = 0;
					} else {
						$tNew = $t;
					}					
					$yVal = $m->e("  (log(y($tNew)) - log($ymin) )*$ymax/($num_y_sections*log($logBase)) ");			
					if ($yVal > $ymin-0.6*($ymax-$ymin) && $yVal < $ymax+0.6*($ymax-$ymin)) {
						array_push ($pth, [$t, $yVal]);
					}
					$yValRem = $yVal;
				}
			} else if($axesType == "loglog") { // This converts x pixel values to cartesian, and outputs y-values in pixels
				$logBase = 10;
				$num_x_sections = log($xmax/$xmin)/log($logBase) ;
				$widthSection = ($width-2*$padding)/$num_x_sections;
				$num_y_sections = log($ymax/$ymin)/log($logBase) ;
				$inc = ($width+$incBit)/$points;		
				for ($t = $padding; $t <= $width+$inc; $t += $inc) {		
					$tCartesianVal = $xmin * pow($logBase, $num_x_sections * ($t-$padding) / ($width-2*$padding));
					$yValCartesian = $m->e("  y($tCartesianVal) ");
					$y_pixels = (log($yValCartesian)-log($ymin))*($height)/($num_y_sections*log($logBase));
					$yVal = $m->e(" (   ($height - $padding*(1-2*$y_pixels/$height)) -  $y_pixels   )") ;
					array_push ($pth, [$t, $yVal]);
					$yValRem = $yVal;
				}
			} else if($axesType == "linlog") { // This also converts x pixel values to cartesian, and outputs y-values in pixels
				$logBase = 10;
				$num_x_sections = log($xmax/$xmin)/log($logBase) ;
				$widthSection = ($width-2*$padding)/$num_x_sections;
				$inc = ($width+$incBit)/$points;		
				for ($t = $padding; $t <= $width+$inc; $t += $inc) {		
					$tCartesianVal = $xmin * pow($logBase, $num_x_sections * ($t-$padding) / ($width-2*$padding));
					$yValCartesian = $m->e("  y($tCartesianVal) ");
					array_push ($pth, [$t, $yValCartesian]);
				}
			} else {
				for ($t = $min; $t <= $max+$incBit; $t += $inc) {	
					if(abs($t) < 0.00000001) {  // evalMath class didn't cope if value very close to 0
						$tNew = 0;
					} else {
						$tNew = $t;
					}
					$yVal = $m->e("y($tNew)");
					if ($yVal > $ymin-0.6*($ymax-$ymin) && $yVal < $ymax+0.6*($ymax-$ymin)) {
						array_push ($pth, [$t, $yVal]);
					}
					$yValRem = $yVal;
				}			
			}
		} else { 
			echo "<div class=\"svgphpgrapherwarn\">There's a problem with your function:<br> $fun</div>";
			return;
		}
	}	
	$svg .= path($pth, '', '', $attrs,$brdParams);   //path($plist,$id,$c, $attrs,$brdParams )
	return $svg;  
}

function polarAxes($rGap,$labels,$degRad,$qGap,$angLabelGap, $gridAttrs, $axesAttrs, $brdParams){
	if(is_array($brdParams)) {
		foreach($brdParams as $key=>$val){
			${$key} = $val;
			//echo "$key=$val<br>";
		}	
	} else {
		echo "<div class=\"svgphpgrapherwarn\">There's a problem. Do you have the correct number of parameters for the <code>".__FUNCTION__."</code> function?</div>";
		return;
	}
	$svg = '';
	$rMax = max(abs($xmin), abs($xmax), abs($ymin));	
	$axisVblClass = 'intmath';
	if($degRad == "deg") {
		$qGap = $qGap*pi()/180;
	} 
	for($i=0;$i<2*pi(); $i+=$qGap) {
		if($i<pi()) {
			$svg .= segment([-$rMax*cos($i),-$rMax*sin($i)], [$rMax*cos($i), $rMax*sin($i)],  $gridAttrs,$brdParams);
		}
		if( (abs($i - 2*pi())>0.1) && round($i*180/pi(),2)%$angLabelGap == 0) {
			if($degRad == "deg") {
				$num = round($i*180/pi(),2)."&#176;";  // this is &deg;
			} else {
				$num = round($i,2);
			}
			$svg .= text([1.12*$rMax*cos($i), 1.12*$rMax*sin($i)],$num ,"", $axisVblClass, $axesAttrs,$brdParams);
		}
	}
	$axisVblClass = 'intmath';
	for($i=0;$i<$rMax+1; $i+=$rGap) {
		$svg .= circle([0,0],$i,"", $axesAttrs, $brdParams); //circle($center,$radius,$id, $attrs, $brdParams) 
		if(strlen($labels)>0) {
			$svg .= text([$i,0],$i,"below", $axisVblClass, $axesAttrs,$brdParams);	
			//$svg .= text([0,$i],$i,"left", $axisVblClass, $attrs,$brdParams);
		}
	}
	return $svg;
}

function polarplot($fun,$x_min,$x_max,$points, $attrs,$brdParams) {
	// For testing: 
	$ptsSum = 0; $minHoriz = 2000000000; $maxHoriz = -2000000000; $minVert = 2000000000; $maxVert = -2000000000; 
	//
	if(is_array($brdParams)) {
		foreach($brdParams as $key=>$val){
			${$key} = $val;
			//echo "$key=$val<br>";
		}	
	} else {
		echo "<div class=\"svgphpgrapherwarn\">There's a problem. Do you have the correct number of parameters for the <code>".__FUNCTION__."</code> function?</div>";
		return;
	}
	$m = new EvalMath;
	$pth = array();
	if($x_min==='' || $x_min == $xmin) {
		$min = $xmin-$padding/$xunitlength;
	} else {
		$min = $x_min;
	}
	if($x_max==='' || $x_max == $xmax) {
		$incBit = ($xmax - $xmin)/200;
		$max = $xmax + $padding/$xunitlength + $incBit;
	} else {
		$max = $x_max;
		$incBit = 0;
	}
	$inc = $max-$min-0.000001*($max-$min);
	$inc = ($points==null?$inc/200:$inc/$points);
	$incOrig = $inc;
	$doOnceL = 0; $doOnceR = 0; $wasAnumber = 0; $discRem = 0;
	if(strstr($fun, 'q') && !strstr($fun, 'x')) {
		$LHS = 'y(q)';
	} else {
		$LHS = 'y(x)';
	}
	if ($m->evaluate($LHS .' = '.$fun) ) {
		for ($t = $min; $t <= $max+$incBit; $t += $inc) {			
			if(abs($t) < 0.0001) {  // evalMath class didn't cope if value very close to 0
				$tNew = 0;
			} else {
				$tNew = $t;
			}
			$yVal = $m->e("y($tNew)");
			if(isset($yValRem)) {
				$dydx = ($yVal - $yValRem)*$yunitlength/($inc*$xunitlength);
				if(abs($dydx) > 5  && ($yVal > $ymin && $yVal < $ymax) ) {
					$inc = $incOrig/10;
				} else  {
					$inc = $incOrig;
				}
			}
			if ($yVal > $ymin-0.6*($ymax-$ymin) && $yVal < $ymax+0.6*($ymax-$ymin)) {
				// Testing
				$ptsSum++;
				$minHoriz = min($t, $minHoriz); 
				$maxHoriz = max($t, $maxHoriz); 
				$minVert = min($yVal, $minVert);
				$maxVert = max($yVal, $maxVert); 			
				//
				array_push ($pth, [cos($t)*$yVal, sin($t)*$yVal]);
			}
			$yValRem = $yVal;
		}
	} else { 
		echo "<div class=\"svgphpgrapherwarn\">There's s problem with your function:<br> $fun</div>";
		return;
	}	
	$svg = path($pth, '', '', $attrs,$brdParams);   //path($plist,$id,$c, $attrs,$brdParams )
	return $svg;  
}

function polygon($ptsArr,$attrs,$brdParams) { // pts, style attributes, board parameters
	if(is_array($brdParams)) {
		foreach($brdParams as $key=>$val){
			${$key} = $val;
			//echo "$key=$val<br>";
		}	
	} else {
		echo "<div class=\"svgphpgrapherwarn\">There's a problem. Do you have the correct number of parameters for the <code>".__FUNCTION__."</code> function?</div>";
		return;
	}
	$svg = "<polygon ";
	$attrArr = explode(";", $attrs);
	foreach($attrArr as $attPairs) {
	  $attPairsArr = explode(":", trim($attPairs));
	  $svg .= "$attPairsArr[0]=\"$attPairsArr[1]\" ";		  
	}	
	$svg .= "points=\"";
	foreach($ptsArr as $p) {
		$svg .= (round($p[0]*$xunitlength+$ox,2)).",".(round($height - $p[1]*$yunitlength-$oy,2)). " ";
	}
	$svg .= "\" ";

	$svg .= ">";
	$svg .= "</polygon>\n";
	return $svg;
}



function rect($p,$q,$attrs,$brdParams) { // bottLeft,topRight, style attributes, board parameters
	if(is_array($brdParams)) {
		foreach($brdParams as $key=>$val){
			${$key} = $val;
			//echo "$key=$val<br>";
		}	
	} else {
		echo "<div class=\"svgphpgrapherwarn\">There's a problem. Do you have the correct number of parameters for the <code>".__FUNCTION__."</code> function?</div>";
		return;
	}
	$svg = "<rect ";
	$attrArr = explode(";", $attrs);
	foreach($attrArr as $attPairs) {
	  $attPairsArr = explode(":", trim($attPairs));
	  $svg .= "$attPairsArr[0]=\"$attPairsArr[1]\" ";		  
	}	
	$svg .= "x=\"".(round($p[0]*$xunitlength+$ox,2))."\" ";
	$svg .= "y=\"".(round($height - $q[1]*$yunitlength-$oy,2))."\" ";
	$svg .= "width=\"".round(($q[0]-$p[0])*$xunitlength,2)."\" ";
	$svg .= "height=\"".round(($q[1]-$p[1])*$yunitlength,2)."\" ";

	$svg .= ">";
	$svg .= "</rect>\n";
	return $svg;
}

function square($p,$squareWidth, $attrs,$brdParams) { // bottLeft, width, style attributes, board parameters
	if(is_array($brdParams)) {
		foreach($brdParams as $key=>$val){
			${$key} = $val;
			//echo "$key=$val<br>";
		}	
	} else {
		echo "<div class=\"svgphpgrapherwarn\">There's a problem. Do you have the correct number of parameters for the <code>".__FUNCTION__."</code> function?</div>";
		return;
	}
	return rect($p,[($p[0]+$squareWidth), ($p[1]+$squareWidth)],$attrs,$brdParams);
}

function triangle($p,$q,$r, $attrs,$brdParams) { // Points P, Q, R, style attributes, board parameters
	if(is_array($brdParams)) {
		foreach($brdParams as $key=>$val){
			${$key} = $val;
			//echo "$key=$val<br>";
		}	
	} else {
		echo "<div class=\"svgphpgrapherwarn\">There's a problem. Do you have the correct number of parameters for the <code>".__FUNCTION__."</code> function?</div>";
		return;
	}
	$st = "<path ";
	$attrs = trim($attrs,";");
	$attrArr = explode(";", $attrs);
	if(substr_count($attrs, ";") > 0) {
		foreach($attrArr as $attPairs) {
			$attPairsArr = explode(":", trim($attPairs));
			$st .= "$attPairsArr[0]=\"$attPairsArr[1]\" ";
		}
	}
	$st .= "d = \"M".round($p[0]*$xunitlength+$ox,2).",".(round($height - $p[1]*$yunitlength-$oy,2))." L ".round($q[0]*$xunitlength+$ox,2).",".(round($height - $q[1]*$yunitlength-$oy,2))." L ".round($r[0]*$xunitlength+$ox,2).",".(round($height - $r[1]*$yunitlength-$oy,2))." z \"";			
	$st .= ">";
	$st .= "</path>\n";
	$svg = $st;	
	return $svg;
}

function segArrow($p, $q,  $segAttrs, $arrAttrs,$brdParams) {
	if(is_array($brdParams)) {
		foreach($brdParams as $key=>$val){
			${$key} = $val;
			//echo "$key=$val<br>";
		}	
	} else {
		echo "<div class=\"svgphpgrapherwarn\">There's a problem. Do you have the correct number of parameters for the <code>".__FUNCTION__."</code> function?</div>";
		return;
	}
	$rotateAngleRad = getRotAteangle($p, $q, $xunitlength, $yunitlength);
	$rotateAngleDeg = (180/pi())*$rotateAngleRad;
	if(!isset($triRotate)) {
		$triRotate = $rotateAngleDeg;
	}
	$svg = '';
	$attrs = trim($arrAttrs, ";");  // Note arr
	$attrArr = explode(";", $attrs);
	$attrArrVals = array();
	foreach($attrArr as $attPairs) {
		$attPairsArr = explode(":", trim($attPairs));
		foreach($attPairsArr as $key=>$val){
			${$key} = $val;			
		}
		$thisKey = str_replace("-", "", $attPairsArr[0]);
		$$thisKey = $attPairsArr[1];
	}
	if($q[0] == $xmax) {
		$includePadding = $padding;
	} else {
		$includePadding = 0;
	}
	if($p[0] == $q[0]) {
		$newQ0 = round($q[0], 3);
	} else {
		$newQ0 = round($q[0]  - ($includePadding)/$xunitlength, 3);
	}
	$newQ1 = round($q[1] , 3);
	$svg .= arrowHead ($p, [$newQ0, $newQ1], $arrAttrs,$brdParams);
	if($p[0] == $q[0]) {
		if( $p[1] > $q[1]) {
			$newQ0 = round($q[0], 3);
			$newQ1 = round($q[1] + ($triHeight*0.75)/$yunitlength, 3);

			
		}
	} else {
		$newQ0 = round($q[0] - (($triHeight*0.75)*cos($rotateAngleRad) - $includePadding)/$xunitlength, 3);
		$newQ1 = round($q[1] + ($triHeight*0.75)*sin($rotateAngleRad)/$yunitlength, 3);	
	}
	$svg .= segment([$p[0],$p[1]], [$newQ0,   $newQ1],  $segAttrs,$brdParams);	
	return $svg;	
}

function segment($p,$q,$attrs,$brdParams) {
	if(is_array($brdParams)) {
		foreach($brdParams as $key=>$val){
			${$key} = $val;
			//echo "$key=$val<br>";
		}	
	} else {
		echo "<div class=\"svgphpgrapherwarn\">There's a problem. Do you have the correct number of parameters for the <code>".__FUNCTION__."</code> function?</div>";
		return;
	}
	$svg = "<path ";
	$attrs = trim($attrs, ";");
	$attrArr = explode(";", $attrs);
	$attrArrVals = array();
	foreach($attrArr as $attPairs) {
		$attPairsArr = explode(":", trim($attPairs));
		foreach($attPairsArr as $key=>$val){
			${$key} = $val;			
		}
		$thisKey = str_replace("-", "", $attPairsArr[0]);
		$$thisKey = $attPairsArr[1];
	}
	if(isset($stroke)) {$svg .= "stroke=\"$stroke\" ";} else {$svg .= "stroke=\"#000\" ";}
	if(isset($strokewidth)) {$svg .= "stroke-width=\"$strokewidth\" ";} else {$svg .= "stroke=\"1\" ";}
	if(isset($opacity)) {$svg .= "opacity=\"$opacity\" ";}
	if(isset($strokedasharray)) {$svg .= "stroke-dasharray=\"$strokedasharray\" ";}	
	if(isset($shaperendering)) {$svg .= "shape-rendering=\"$shaperendering\" ";}
	$svg .= "d=\"M".round($p[0]*$xunitlength + $ox).", ".round($height - $p[1]*$yunitlength - $oy)." ".round($q[0]*$xunitlength + $ox) .", ". round($height - $q[1]*$yunitlength - $oy)."\""; 
	$svg .= ">";
	$svg .= "</path>\n";
	return $svg; 
}

function text($p,$str,$pos,$class,$attrs,$brdParams) { 	// point, string, position, attrs, brdParams
	if(is_array($brdParams)) {
		foreach($brdParams as $key=>$val){
			${$key} = $val;
			//echo "$key=$val<br>";
		}	
	} else {
		echo "<div class=\"svgphpgrapherwarn\">There's a problem. Do you have the correct number of parameters for the <code>".__FUNCTION__."</code> function?</div>";
		return;
	}	
	if(strstr($str, "`") || strlen($str) != strlen(strip_tags($str))) {
		 // contains ASCIIMath or HTML
		$htmlTxt = "<div class=\"$class svgHtml\" style=\"top:".round($height - $p[1]*$yunitlength-$oy-$padding)."px;left:".round($p[0]*$xunitlength+$ox)."px\">$str</div>\n";
	   return $htmlTxt;		 
	} else {	
		
		$str = str_replace("&minus;", "&#8722;", $str);
		$str = str_replace("&pi;", "&#960;", $str);
		$str = str_replace("&deg;", "&#176;", $str);
		$str = str_replace("&alpha;", "&#945;", $str);			
		$str = str_replace("&theta;", "&#952;", $str);
		$str = str_replace("&radic;", "&#8730;", $str);
		$str = str_replace("&Delta;", "&#916;", $str);
		
		
		if($attrs == "gridsAru") {
			$filter = 'filter="url(#solid)" ';
			$filter = '';
		} else {
			$filter = '';
			
		}
		$bgRect = '';
		$svg = '<text '.$filter;
		$fontsize = 16;
		$textanchor = "middle";
		$dx = 0; $dy = $fontsize/3;
		if ($pos!=null) {
		 if ($pos=="above") $dy = -$fontsize/2-3;
		 if ($pos=="below") $dy = $fontsize+2;
		 if ($pos=="right") {
			$textanchor = "start";
			//$dx = $fontsize/2+5;
			$dx = $fontsize/2;
		 }
		 if ($pos=="rightAx") {
			$textanchor = "start";
			$dx = $fontsize/2+5;
		 }		 
		 if ($pos=="left") {
			$textanchor = "end";
			$dx = -$fontsize/2;
		 }
		}
		$svg .= "x=\"".round($p[0]*$xunitlength+$ox+$dx)."\" ";
		$svg .= "y=\"".round($height - $p[1]*$yunitlength-$oy+$dy)."\" ";
		$attrs = trim($attrs, ";");
		if(substr_count($attrs, ";") > 0) {
		  $attrArr = explode(";", $attrs);
		  foreach($attrArr as $attPairs) {
			  $attrArr = explode(";", $attrs);
			  $attPairsArr = explode(":", trim($attPairs));
			  if($attPairsArr[0] != "stroke-width" && $attPairsArr[0] != "stroke" && !($attPairsArr[0] == "fill" && $attPairsArr[1] == "none")) {
				  $svg .= "$attPairsArr[0]=\"$attPairsArr[1]\" ";		  
			  }
			 		  
		  }
		}
		$svg .= "class=\"$class\" ";
		$svg .= "text-anchor=\"$textanchor\"";
		$svg .= ">";
		$svg .= $str;
		$svg .= "</text>\n";
		$svg = $bgRect.$svg;
		return $svg;
	}
}

///////////////////////////////////////
//
// InitBoard, createSVG and doOutput
//
///////////////////////////////////////
function initBoard($boardID, $width, $height, $x_min, $x_max, $y_min, $y_max, $axesType, $svgTitle, $res2, $res3, $padding){
	// $boardNum is set in top.php for main loop; or at the top of each ans-*.php file
	// $boardID is then set at the top of each graph, using $boardID = "svgphp-$brdNum"; $brdNum++;
	// This next bit is for remaining non-loop cases, to give unique ID for board
	if(substr_count($boardID, '-') == 1) {
		if(!strstr($_SERVER["REQUEST_URI"], "/forum/")) {
			// Need to do this here because called before nonloopTop.php is called
			$serverSelf = $_SERVER["PHP_SELF"]; // directory and file name
			$parts = Explode('/', $serverSelf);
			$currentFile = $parts[count($parts) - 1];	
			
			// FAILED in PHP 7.2
			// Following "shortcode" is based on http://www.snippetit.com/2009/04/php-short-url-algorithm-implementation/
			
			/*$base32 = array ('a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5' );
			$hex = md5($currentFile); echo "$hex<br>";
			$hexLen = strlen($hex);
			$subHexLen = $hexLen / 8;
			$output = array();
			for ($i = 0; $i < $subHexLen; $i++) {
				$subHex = substr ($hex, $i * 8, 8); echo "$subHex<br>";
				$int = hexdec(0x3FFFFFFF & (hexdec('0x'.$subHex))); 
echo (('0x'.$subHex)).", int=$int<br>";
				$out = '';
				for ($j = 0; $j < 6; $j++) {
					$val = 0x0000001F & $int;
					$out .= $base32[$val];
					$int = $int >> 5;
				}
				$output[] = $out;
				
			// DUN WERK	
			// See https://stackoverflow.com/questions/959957/php-short-hash-like-url-shortening-websites
			$base64 = intval($currentFile, 64);
			}*/
			
			

			$hex = md5($currentFile);// echo substr($hex,0,6)."<br>";
			$boardID = str_replace("svgphp-", "svgphp-".substr($hex,0,6)."-", $boardID);
		} else {
			$reqArr = explode("/", $_SERVER["REQUEST_URI"]);
			//echo $reqArr[count($reqArr)-1];
			// Include post_id for uniqueness of cached svg files
			// But replace : with - o/wise causes 403s
			$reqFile = str_replace(":","-",$reqArr[count($reqArr)-1]);
			//explode(":", $reqArr[count($reqArr)-1])[0];
			//echo $reqFile;
			//exit;
			$boardID = str_replace("svgphp-", "svgphp-".$reqFile."-", $boardID);
		}
		
		//echo $boardID."<br>";
	}
	// Initialize arrays for each board
	$svgArr = [];	
	$htmlArr = [];
	// Create wrapper div (so HTML text boxes end up in the right place)
	$svgArr[] = "<div class=\"svgphpWrap\">\n";
	// Create svg
	$svgArr[] = '<svg ';
	$svgArr[] = "id=\"$boardID\" ";
	$svgArr[] = "width=\"$width\" ";
	$svgArr[] = "height=\"$height\" ";
	//$svgArr[] = "preserveAspectRatio=\"none\" ";	
	$svgArr[] = 'preserveAspectRatio="xMinYMin meet" viewBox="0 0 '.$width.' '.$height.'" ';
	$svgArr[] = 'xmlns="http://www.w3.org/2000/svg"';  // xmlns:svg="http://www.w3.org/2000/svg" version="1.2"
	( $x_min!== null ? $xmin = $x_min:$xmin = -5);
	($x_max!==null? $xmax = $x_max:$xmax = 5);
	if ($y_min!==null) $ymin = $y_min;
	$ymax = $y_max;
	$xunitlength = ($width-2*$padding)/($xmax-$xmin);
	$yunitlength = $xunitlength;	
	if ($ymin==='') {
		$origin = [-$xmin*$xunitlength+$padding,$boardHeight/2];
		$ymin = -($height-2*$padding)/(2*$yunitlength);
		$ymax = -$ymin;
	} else {
		if ($ymax!=null) {
			$yunitlength = ($height-2*$padding)/($ymax-$ymin);
		} else {  // Equally scaled axes case			
			$ymax = $ymin + ($height - 2*$padding)/$yunitlength ;
		}
		$origin = [-$xmin*$xunitlength+$padding,-$ymin*$yunitlength+$padding];
	}
	$svgArr[] = ">\n";
	if(strlen($svgTitle)>0) { $svgArr[] = "<title>$svgTitle</title>";	}
	//$svgArr[] = '<defs><filter x="0" y="0" width="1" height="1" id="solid"><feFlood flood-color="white"/><feComposite in="SourceGraphic"/></filter></defs>';
	
//$svgArr[] = "<style type=\"text/css\">@font-face {font-family:MathJax_Math-italic;src:url('/includes/cssjs/katex/fonts/MathJax_Math-Italic.eot');src:url('/includes/cssjs/katex/fonts/MathJax_Math-Italic.eot?#iefix') format('embedded-opentype'),url(/includes/cssjs/katex/fonts/MathJax_Math-Italic.woff2) format('woff2'),url('/includes/cssjs/katex/fonts/MathJax_Math-Italic.woff') format('woff');}@font-face{font-family: MathJax_Main;src: url('/includes/cssjs/katex/fonts/MathJax_Main-Regular.eot');src:url('/includes/cssjs/katex/fonts/MathJax_Main-Regular.eot?#iefix') format('embedded-opentype'),url(/includes/cssjs/katex/fonts/MathJax_Main-Regular.woff2) format('woff2'),url('/includes/cssjs/katex/fonts/MathJax_Main-Regular.woff')format('woff')};path.grids{shape-rendering:crispEdges} text.intmath{font-weight:normal;font-size:0.9em; stroke:none; fill:#000; font-family:MathJax_Main,'Times New Roman',Times,serif} text.intmathItalic{font-size:0.9em;stroke:none; fill:#000; font-weight:normal; font-style:normal; font-family:MathJax_Math-italic,'Times New Roman',Times,serif}</style>\n";	


// LATEST!!
	$svgArr[] = "<style>text.intmath,text.intmathItalic{stroke:none;fill:#000;font-weight:400}@font-face{font-family:MathJax_Math-italic;src:url(/includes/cssjs/katex/fonts/MathJax_Math-Italic.woff2) format('woff2'),url(/includes/cssjs/katex/fonts/MathJax_Math-Italic.woff) format('woff')}@font-face{font-family:MathJax_Main;src:url(/includes/cssjs/katex/fonts/MathJax_Main-Regular.woff2) format('woff2'),url(/includes/cssjs/katex/fonts/MathJax_Main-Regular.woff) format('woff')}path.grids{shape-rendering:crispEdges}text.intmath{font-size:14.4px;font-family:MathJax_Main,'Times New Roman',Times,serif}text.intmathItalic{font-size:16px;font-style:normal;font-family:MathJax_Math-italic,'Times New Roman',Times,serif}</style>\n";
	$brdParams = array("boardID"=> $boardID, "xmin"=> $xmin, "ymin"=> $ymin, "xmax"=> $xmax, "ymax"=> $ymax, "width"=>$width, "height"=>$height, "xunitlength"=>$xunitlength, "yunitlength"=>$yunitlength, "ox"=>$origin[0], "oy"=>$origin[1], "axesType" => $axesType, "padding"=>$padding );	
	// Create board
	$attrs = 'id:brdBG-'.$boardID.'; stroke:none; fill:#fff';
	$svgArr[] = rect([$xmin-$padding/$xunitlength,$ymin-$padding/$yunitlength],[$xmax+$padding/$xunitlength,$ymax+$padding/$yunitlength],$attrs, $brdParams); //rect($p,$q,$attrs,$brdParams)
	return array($svgArr, $htmlArr, $brdParams);
}


function createSVG($svgArr,$htmlArr,$svgFilename,$theSvg) {
//echo "NOT cache!; $svgFilename";
//echo count($htmlArr);
//print_r($svgArr);
//print_r($htmlArr);	
	foreach($svgArr as $svgEls) {		
		// This is mostly for vertical log axis (log-log and log-lin axes type).
		// For labels that are in powers of 10
		if(strstr($svgEls, "<text")) {
			preg_match_all('/<text(.*?)<\/text>/s', $svgEls, $textXml);
			foreach($textXml[0] as $htmlTxt) {
				$innerTxt =  get_string_between($htmlTxt, ">", "</text>");
				if(strstr($innerTxt, "`")  || strlen($innerTxt) != strlen(strip_tags($innerTxt)) ) {
					preg_match_all('/<text(.*?)>/s', $htmlTxt, $theAttrs);
					$eachAttrArr = explode(" ", trim($theAttrs[1][0]));
					foreach($eachAttrArr as $key=>$val) {
						$attrsArr = explode("=", str_replace('"','',$val));
						$attr = [];
						foreach ($attrsArr as $attr=>$attVal) {
							${$attrsArr[0]} = $attrsArr[1];
						}							
					} 
					$htmlArr[] = "<div class=\"intmath svgHtml\" style=\"left:".round($x-8)."px;top:".round($y-15)."px\"><span>$innerTxt</span></div>\n";
					$svgEls = str_replace($htmlTxt  , '', $svgEls);
				}
			}
		}
		// On first create, don't echo <style> to page
		// (Cached version has <style> for standalone case, but also not echoed to screen.)
		if( !strstr($svgEls, "<style") ) {
			echo $svgEls;
		}
	}
	//echo "</div>";
	$htmlArr[] = "</div><!-- svgphpWrap -->\n";

	foreach($htmlArr as $htmlEls) {
		echo $htmlEls;
	}	
	if(!file_exists('svg')){
		mkdir('svg', 0755);	
	}	
	fopen($svgFilename, 'w');			
	if (is_writable($svgFilename)) {
		if (!$handle = fopen($svgFilename, 'w')) {
			echo "Cannot open file ($svgFilename)";
			exit;
		}		
		// Write $theSvg to our opened file.
		// This includes <style> tag, for standalone case
		if (fwrite($handle, $theSvg) === FALSE) {
			echo "Cannot write to file ($svgFilename)";
			exit;
		} 
		fclose($handle);
	} else {
		echo "The file $svgFilename is not writable";
	}		
}

function doOutput ($svgArr,$htmlArr ) {
	$svgArr[] = "</svg>\n"; //printR($svgArr);
	$theSvg = preg_replace( "/\r|\n/", "", implode($svgArr) );
	$theSvg = str_replace('<div class="svgphpWrap">', '', $theSvg);
	$theSvg = str_replace('<![CDATA[', '', $theSvg);
	$theSvg = str_replace(']]>', '', $theSvg);
	$brdID = get_string_between($theSvg, '<svg id="', '"');	
	$svgFilename = 'svg/'.$brdID.'.svg';

	// If SVG exists, and is "fresh", display it.
	// If page is newer or svgPHPGrapher is newer, OR involves HTML elements, build the SVG again.	

	$req = $_SERVER['REQUEST_URI'];
	$reqUriParts = explode('/', $req);
	$reqCurrentDir = $reqUriParts[1];
	//echo $reqCurrentDir;
	
	if(file_exists($svgFilename) && $reqCurrentDir != "phys") {
		$grapherModTime = date ("Y-m-d H:i:s.", filemtime(__FILE__)); // This svgPHPGrapher file
		$parentFile = $_SERVER["SCRIPT_NAME"];
		$parentFileModTime = date ("Y-m-d H:i:s.", getlastmod());	
		$svgModTime = date ("Y-m-d H:i:s.", filemtime($svgFilename));		
		if( filesize($svgFilename) > 0 ) {			
			$cachedSvg = file_get_contents($svgFilename);
			if(strstr($cachedSvg, "`")  || strstr($cachedSvg, "<sup>") || strstr($cachedSvg, "<i>") || count($htmlArr)>0) {
				//echo "has HTML elements. Don't use cache.";
				createSVG($svgArr,$htmlArr,$svgFilename,$theSvg);
			} else if ( strtotime($grapherModTime) > strtotime($svgModTime) || strtotime($parentFileModTime) > strtotime($svgModTime) ) {
				//echo "not SUP - create new";
				createSVG($svgArr,$htmlArr,$svgFilename,$theSvg);	
			} else {
				//echo "CACHE!";
				echo "<div class=\"svgphpWrap\">";
				$includedFilesArr = get_included_files();
//print_r($includedFilesArr);				
//echo $includedFilesArr[count($includedFilesArr)-1];				
				if( !strstr($includedFilesArr[count($includedFilesArr)-1], "downloadGraphPaper.php") ) {
					echo '<a href="svg/'.$brdID.'.svg">';
				}
				// Don't include svg's <style> within page (but linked to standalone does have <style>)...
				// ... since not needed on page and can influence page styles
				// Font-size is determined by page CSS for svgPHP...
				// (... and by style=".." attribute in ASCIIsvg-IM.js)
				$theStyle = get_string_between($cachedSvg, '<style', '</style>');
				$cachedSvg = str_replace( '<style'.$theStyle.'</style>', "", $cachedSvg);
				echo trim($cachedSvg);
				if( !strstr($includedFilesArr[count($includedFilesArr)-1], "downloadGraphPaper.php") ) {
					echo '<span class="ariaHidden">Open image in a new page</span></a>';
				}

				echo "</div>";
			}
		}		
	} else {	 
		createSVG($svgArr,$htmlArr,$svgFilename,$theSvg);
	}	
}
?>